/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.ISEntityManagerProvider;
import org.gcube.data.analysis.tabulardata.cube.metadata.TableConsistencyChecker;
import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATable;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATableFactory;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.TableFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Default
@Singleton
public class JPACubeMetadataWrangler
implements CubeMetadataWrangler {
    Logger log = LoggerFactory.getLogger(JPACubeMetadataWrangler.class);
    EntityManager em = null;
    ISEntityManagerProvider emp;

    @Inject
    public JPACubeMetadataWrangler(ISEntityManagerProvider emp) {
        this.emp = emp;
    }

    @Override
    public Table save(Table table) {
        TableConsistencyChecker.checkTableConsistency(table);
        JPATable jpaTable = JPATableFactory.createJPATable(table);
        this.persistEntity(jpaTable);
        return TableFactory.createTable(jpaTable);
    }

    private void initializeIfNot() {
        if (this.em == null) {
            this.em = this.emp.get();
        }
    }

    @Override
    public Table get(TableId id) throws NoSuchTableException {
        return TableFactory.createTable(this.getJPATableById(id.getValue()));
    }

    @Override
    public List<Table> getAll() {
        return Lists.transform(this.getAllJPATables(), (Function)new Function<JPATable, Table>(){

            public Table apply(JPATable input) {
                return TableFactory.createTable(input);
            }
        });
    }

    @Override
    public List<Table> getAll(TableType tableType) {
        return Lists.transform(this.getAllJPATablesByType(tableType), (Function)new Function<JPATable, Table>(){

            public Table apply(JPATable input) {
                return TableFactory.createTable(input);
            }
        });
    }

    @Override
    public void remove(TableId id) throws NoSuchTableException {
        this.removeEntity(this.getJPATableById(id.getValue()));
    }

    private JPATable getJPATableById(long id) throws NoSuchTableException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Table.findById", JPATable.class);
        query.setParameter("Id", (Object)id);
        List queryResult = query.getResultList();
        if (queryResult.size() > 0) {
            return (JPATable)queryResult.get(0);
        }
        throw new NoSuchTableException(id);
    }

    private List<JPATable> getAllJPATables() {
        TypedQuery query = this.getEntityManager().createNamedQuery("Table.findAll", JPATable.class);
        return query.getResultList();
    }

    private List<JPATable> getAllJPATablesByType(TableType tableType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Table.findAllByType", JPATable.class);
        query.setParameter("TableType", (Object)tableType);
        return query.getResultList();
    }

    private void persistEntity(Object entity) {
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().persist(entity);
        this.getEntityManager().getTransaction().commit();
        this.log.debug("Saved entity: " + entity);
    }

    private void removeEntity(Object entity) {
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().remove(entity);
        this.getEntityManager().getTransaction().commit();
    }

    private EntityManager getEntityManager() {
        this.initializeIfNot();
        return this.em;
    }
}

