/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import java.util.ArrayList;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPAColumn;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATable;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public class JPATableFactory {
    public static JPATable createJPATable(Table table) {
        JPATable result = new JPATable();
        result.setName(table.getName());
        result.setTableType(table.getTableType());
        for (Column column : table.getColumns()) {
            result.getColumns().add(JPAColumnFactory.createJPAColumn(column));
        }
        result.getMetadata().addAll(table.getAllMetadata());
        return result;
    }

    public static JPATable updateJPATable(JPATable jpaTable, Table table) {
        jpaTable.setName(table.getName());
        jpaTable.setTableType(table.getTableType());
        ArrayList<JPAColumn> columns = new ArrayList<JPAColumn>();
        for (Column column : table.getColumns()) {
            columns.add(JPAColumnFactory.createJPAColumn(column));
        }
        jpaTable.setColumns(columns);
        jpaTable.getMetadata().addAll(table.getAllMetadata());
        return jpaTable;
    }

    private static class JPAColumnFactory {
        private JPAColumnFactory() {
        }

        public static JPAColumn createJPAColumn(Column column) {
            JPAColumn result = new JPAColumn();
            result.setLocalId(column.getLocalId().getValue());
            result.setName(column.getName());
            result.setType(column.getColumnType());
            result.setDataType(column.getDataType());
            result.setRelationship(column.getRelationship());
            result.getMetadata().addAll(column.getAllMetadata());
            return result;
        }
    }
}

