/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers.dataset;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.AttributeColumn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.column.MeasureColumn;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnIsOfType;
import org.gcube.data.analysis.tabulardata.model.idioms.TransformColumn;
import org.gcube.data.analysis.tabulardata.model.table.Dataset;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public class DatasetCreator
extends DefaultTableCreator {
    private List<Column> newColumns = Lists.newArrayList();
    private Table clonedTable;
    private List<Column> columnsToRemove = Lists.newArrayList();
    private boolean withData;

    public DatasetCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler, TableManager tableManager) {
        super(dbWrangler, cmWrangler, tableManager);
    }

    @Override
    protected Collection<Column> getAllColumns() {
        ArrayList columns = Lists.newArrayList();
        if (this.clonedTable != null) {
            columns.addAll(this.clonedTable.getColumns());
            columns.removeAll(this.columnsToRemove);
        }
        while (columns.remove(new IdColumn())) {
        }
        columns.addAll(this.newColumns);
        return columns;
    }

    @Override
    protected Collection<Column> getNewColumns() {
        return this.newColumns;
    }

    private Collection<AttributeColumn> getAttributeColumns() {
        Collection tmp = Collections2.filter(this.getAllColumns(), (Predicate)new ColumnIsOfType(ColumnType.ATTRIBUTE));
        return Collections2.transform((Collection)tmp, (Function)new TransformColumn());
    }

    private Collection<MeasureColumn> getMeasureColumns() {
        Collection tmp = Collections2.filter(this.getAllColumns(), (Predicate)new ColumnIsOfType(ColumnType.MEASURE));
        return Collections2.transform((Collection)tmp, (Function)new TransformColumn());
    }

    @Override
    protected Table createBaseTable(String tableName, Collection<Column> columns) {
        return new Dataset(tableName, columns);
    }

    @Override
    protected void checkConsistency() throws TableCreationException {
        try {
            this.checkDuplicateLabels(this.getAllColumns());
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
        if (this.getAttributeColumns().isEmpty() && this.getMeasureColumns().isEmpty()) {
            throw new TableCreationException("Must provide at least one attribute column or measure column in order to create a dataset.");
        }
        try {
            this.checkColumnsRelationship(this.getAllColumns());
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
    }

    @Override
    protected boolean isAllowedColumn(Column column) {
        switch (column.getColumnType()) {
            case ATTRIBUTE: 
            case MEASURE: 
            case SYSTEM: 
            case CODELISTREF: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addNewColumn(Column column) {
        this.newColumns.add(column);
    }

    @Override
    protected boolean isAllowedCloneableTable(Table table) {
        switch (table.getTableType()) {
            case DATASET: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Table getTableToClone() {
        return this.clonedTable;
    }

    @Override
    protected void setTableToClone(Table table) {
        this.clonedTable = table;
    }

    @Override
    protected boolean isCloneWithData() {
        return this.withData;
    }

    @Override
    protected void setCloneWithData(boolean cloneWithData) {
        this.withData = cloneWithData;
    }

    @Override
    protected Collection<Column> getColumnsToRemove() {
        return this.columnsToRemove;
    }

    @Override
    protected void setColumnsToRemove(Collection<Column> columns) {
        this.columnsToRemove = Lists.newArrayList(columns);
    }

    @Override
    protected void addIndexes(String tableName, Collection<Column> columns) {
    }
}

