/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers.hcl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnIsOfType;
import org.gcube.data.analysis.tabulardata.model.table.HierarchicalCodelist;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public class HCLCreator
extends DefaultTableCreator {
    private List<Column> newColumns = Lists.newArrayList();
    private Table clonedHCL;
    private List<Column> columnsToRemove = Lists.newArrayList();
    private boolean withData;

    public HCLCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler, TableManager tableManager) {
        super(dbWrangler, cmWrangler, tableManager);
    }

    @Override
    protected Collection<Column> getAllColumns() {
        ArrayList columns = Lists.newArrayList();
        if (this.clonedHCL != null) {
            columns.addAll(this.clonedHCL.getColumns());
            columns.removeAll(this.columnsToRemove);
        }
        columns.addAll(this.newColumns);
        while (columns.remove(new IdColumn())) {
        }
        return columns;
    }

    @Override
    protected Collection<Column> getNewColumns() {
        return this.newColumns;
    }

    @Override
    protected Table createBaseTable(String tableName, Collection<Column> columns) {
        return new HierarchicalCodelist(0L, tableName, columns);
    }

    @Override
    protected void checkConsistency() throws TableCreationException {
        try {
            this.checkDuplicateLabels(this.getAllColumns());
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
        boolean hasChildRef = false;
        boolean hasParentRef = false;
        Collection columns = Collections2.filter(this.getAllColumns(), (Predicate)new ColumnIsOfType(ColumnType.CODELISTREF));
        if (columns.size() != 2) {
            throw new TableCreationException("Invalid number of columns of type " + ColumnType.CODELISTREF + ". Only 2 must be provided");
        }
        for (Column column : columns) {
            if (column.getRelationship().isChildParentRelationship()) {
                hasChildRef = true;
                continue;
            }
            hasParentRef = true;
        }
        if (!hasChildRef || !hasParentRef) {
            throw new TableCreationException("Must provide a column of type " + ColumnType.CODELISTREF + " for both a child-parent relationship and a parent-child relationship.");
        }
        try {
            this.checkColumnsRelationship(this.getAllColumns());
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
    }

    @Override
    protected boolean isAllowedColumn(Column column) {
        switch (column.getColumnType()) {
            case SYSTEM: 
            case CODELISTREF: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void addNewColumn(Column column) {
        this.newColumns.add(column);
    }

    @Override
    protected boolean isAllowedCloneableTable(Table table) {
        switch (table.getTableType()) {
            case HIERARCHICALCODELIST: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Table getTableToClone() {
        return this.clonedHCL;
    }

    @Override
    protected void setTableToClone(Table table) {
        this.clonedHCL = table;
    }

    @Override
    protected boolean isCloneWithData() {
        return this.withData;
    }

    @Override
    protected void setCloneWithData(boolean cloneWithData) {
        this.withData = cloneWithData;
    }

    @Override
    protected Collection<Column> getColumnsToRemove() {
        return this.columnsToRemove;
    }

    @Override
    protected void setColumnsToRemove(Collection<Column> columns) {
        this.columnsToRemove = Lists.newArrayList(columns);
    }

    @Override
    protected void addIndexes(String tableName, Collection<Column> columns) {
        for (Column column : columns) {
            switch (column.getColumnType()) {
                case SYSTEM: {
                    return;
                }
            }
            this.dbWrangler.createIndex(tableName, column.getName());
        }
    }
}

