/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasLabel;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public abstract class BaseTableCreator
implements TableCreator {
    protected DatabaseWrangler dbWrangler;
    protected CubeMetadataWrangler mdWrangler;
    protected TableManager tableManager;

    public BaseTableCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler mdWrangler, TableManager tableManager) {
        this.dbWrangler = dbWrangler;
        this.mdWrangler = mdWrangler;
        this.tableManager = tableManager;
    }

    public void checkDuplicateLabels(Collection<Column> columns) throws Exception {
        ArrayList labels = Lists.newArrayList();
        for (Column c : columns) {
            if (labels.contains(c.getLabel())) {
                throw new Exception("Two columns with the same label " + c.getLabel() + " were provided.");
            }
            labels.add(c.getLabel());
        }
    }

    public void setColumnNames(Collection<Column> columns) {
        int i = 0;
        String eligibleName = "field" + i;
        for (Column column : columns) {
            if (column.hasName()) continue;
            while (!Collections2.filter(columns, (Predicate)new ColumnHasName(eligibleName)).isEmpty()) {
                eligibleName = "field" + ++i;
            }
            column.setName(eligibleName);
        }
    }

    public boolean isLabelPresent(String label, List<Column> columns) {
        Collection sameLabelColumns = Collections2.filter(columns, (Predicate)new ColumnHasLabel(label));
        return !sameLabelColumns.isEmpty();
    }

    public void checkColumnsRelationship(Collection<Column> columns) throws Exception {
        for (Column column : columns) {
            if (!column.hasRelationship()) continue;
            try {
                this.tableManager.get(column.getRelationship().getTargetPKRef().getTableId());
            }
            catch (NoSuchTableException e) {
                throw new Exception(String.format("Referenced Codelist with ID %1$s does not exists.", column.getRelationship().getTargetPKRef().getTableId()));
            }
        }
    }

    protected void cloneMetadata(Table sourceTable, Table destTable) {
    }
}

