/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableMetaCreator
implements TableMetaCreator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private CubeMetadataWrangler cmw;
    private Table startingTable;

    public DefaultTableMetaCreator(CubeMetadataWrangler cmw, Table startingTable) {
        this.cmw = cmw;
        this.startingTable = startingTable;
    }

    public TableMetaCreator setTableMetadata(TableMetadata ... metadata) {
        for (TableMetadata cubeMetadata : metadata) {
            this.startingTable.setMetadata(cubeMetadata);
        }
        return this;
    }

    public TableMetaCreator removeTableMetadata(Class<? extends TableMetadata> metadataType) {
        this.startingTable.removeMetadata(metadataType);
        return this;
    }

    public TableMetaCreator removeAllTableMetadata() {
        this.startingTable.removeAllMetadata();
        return this;
    }

    public TableMetaCreator setColumnMetadata(ColumnLocalId columnId, ColumnMetadata ... metadata) {
        try {
            Column column = this.startingTable.getColumnById(columnId);
            column.setAllMetadata((Collection)Lists.newArrayList((Object[])metadata));
        }
        catch (NoSuchColumnException e) {
            this.log.warn(String.format("Column with name %s cannot be found in table\n%s\n, skipping operation.", columnId, this.startingTable));
        }
        return this;
    }

    public TableMetaCreator removeColumnMetadata(ColumnLocalId columnId, Class<? extends ColumnMetadata> metadataType) {
        try {
            Column column = this.startingTable.getColumnById(columnId);
            column.removeMetadata(metadataType);
        }
        catch (NoSuchColumnException e) {
            this.log.warn(String.format("Column with name %s cannot be found in table\n%s\n, skipping operation.", columnId, this.startingTable));
        }
        return this;
    }

    public TableMetaCreator removeAllColumnMetadata(ColumnLocalId columnId) {
        try {
            Column column = this.startingTable.getColumnById(columnId);
            column.removeAllMetadata();
        }
        catch (NoSuchColumnException e) {
            this.log.warn(String.format("Column with name %s cannot be found in table\n%s\n, skipping operation.", columnId, this.startingTable));
        }
        return this;
    }

    public Table create() throws TableCreationException {
        return this.cmw.save(this.startingTable, true);
    }
}

