/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableJobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ImmutableJob
implements Job {
    private float progress = 0.0f;
    private ActivityStatus status = ActivityStatus.INITIALIZING;
    private OperationInvocation invocation;
    @XmlElementRef(type=ImmutableJobResult.class)
    private JobResult result = null;

    private ImmutableJob() {
    }

    public ImmutableJob(float progress, ActivityStatus status, OperationInvocation invocation) {
        this.setProgress(progress);
        this.status = status;
        this.invocation = invocation;
    }

    public ImmutableJob(float progress, ActivityStatus status, OperationInvocation invocation, JobResult result) {
        this.setProgress(progress);
        this.status = status;
        this.invocation = invocation;
        this.result = result;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    private void setProgress(float progress) {
        if (progress < 0.0f || progress > 1.0f) {
            throw new IllegalArgumentException("Progress must be between 0 and 1");
        }
        this.progress = progress;
    }

    @Override
    public ActivityStatus getStatus() {
        return this.status;
    }

    @Override
    public OperationInvocation getSourceInvocation() {
        return this.invocation;
    }

    @Override
    public JobResult getResult() {
        return this.result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImmutableJob [progress=");
        builder.append(this.progress);
        builder.append(", status=");
        builder.append((Object)this.status);
        builder.append(", invocation=");
        builder.append(this.invocation);
        builder.append(", result=");
        builder.append(this.result);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invocation == null ? 0 : this.invocation.hashCode());
        result = 31 * result + Float.floatToIntBits(this.progress);
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableJob other = (ImmutableJob)obj;
        if (this.invocation == null ? other.invocation != null : !this.invocation.equals(other.invocation)) {
            return false;
        }
        if (Float.floatToIntBits(this.progress) != Float.floatToIntBits(other.progress)) {
            return false;
        }
        if (this.result == null ? other.result != null : !this.result.equals(other.result)) {
            return false;
        }
        return this.status == other.status;
    }
}

