/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.CollateralTable;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ImmutableJobResult
implements JobResult {
    private Table output = null;
    private OperationException operationException = null;
    ImmutableList<CollateralTable> collateralTables;

    private ImmutableJobResult() {
    }

    public ImmutableJobResult(Table output) {
        this.output = output;
    }

    public ImmutableJobResult(OperationException operationException) {
        this.operationException = operationException;
    }

    public ImmutableJobResult(Table outputTable, List<CollateralTable> collateralTables) {
        this.output = outputTable;
        this.collateralTables = ImmutableList.copyOf(collateralTables);
    }

    @Override
    public Table getOutput() {
        return this.output;
    }

    @Override
    public OperationException getException() {
        return this.operationException;
    }

    @Override
    public List<CollateralTable> getCollateralTables() {
        return this.collateralTables;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImmutableJobResult [output=");
        builder.append(this.output);
        builder.append(", operationException=");
        builder.append(this.operationException);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collateralTables == null ? 0 : this.collateralTables.hashCode());
        result = 31 * result + (this.operationException == null ? 0 : this.operationException.hashCode());
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableJobResult other = (ImmutableJobResult)obj;
        if (this.collateralTables == null ? other.collateralTables != null : !this.collateralTables.equals(other.collateralTables)) {
            return false;
        }
        if (this.operationException == null ? other.operationException != null : !this.operationException.equals(other.operationException)) {
            return false;
        }
        return !(this.output == null ? other.output != null : !this.output.equals((Object)other.output));
    }
}

