/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.factories.types;

import java.util.List;
import org.gcube.data.analysis.tabulardata.operation.ImmutableOperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

public abstract class BaseWorkerFactory
implements WorkerFactory {
    protected abstract String getOperationName();

    protected abstract String getOperationDescription();

    protected OperationId getOperationId() {
        return new OperationId(this.getClass());
    }

    protected abstract OperationScope getOperationScope();

    protected abstract OperationType getOperationType();

    @Override
    public OperationDescriptor getOperationDescriptor() {
        return new ImmutableOperationDescriptor(this.getOperationId(), this.getOperationName(), this.getOperationDescription(), this.getOperationScope(), this.getOperationType(), this.getParameters());
    }

    protected abstract List<Parameter> getParameters();

    private <T> void checkParameterValue(String id, Class<T> type, OperationInvocation invocation) throws InvalidInvocationException {
        Object obj = invocation.getParameterInstances().get(id);
        if (obj == null) {
            throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing", id));
        }
        Object typedParameter = null;
        try {
            typedParameter = obj;
        }
        catch (Exception e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    private void checkParameter(LeafParameter<?> parameter, OperationInvocation invocation) throws InvalidInvocationException {
        this.checkParameterValue(parameter.getIdentifier(), parameter.getParameterType(), invocation);
    }

    protected void performBaseChecks(OperationInvocation invocation) throws InvalidInvocationException {
        switch (this.getOperationScope()) {
            case COLUMN: {
                this.checkColumnIdPresence(invocation);
            }
            case TABLE: {
                this.checkTableIdPresence(invocation);
            }
        }
        for (Parameter parameter : this.getParameters()) {
            if (!(parameter instanceof LeafParameter) || parameter.getCardinality().getMinimum() <= 0) continue;
            this.checkParameter((LeafParameter)parameter, invocation);
        }
    }

    private void checkTableIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation.getTargetTableId() == null) {
            throw new InvalidInvocationException(invocation, "Target table is missing");
        }
    }

    private void checkColumnIdPresence(OperationInvocation invocation) throws InvalidInvocationException {
        if (invocation.getTargetColumnId() == null) {
            throw new InvalidInvocationException(invocation, "Target column is missing");
        }
    }
}

