/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.invocation;

import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.invocation.ImmutableOperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.invocation.InvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;

public class ColumnScopedInvocationCreator
extends InvocationCreator {
    private TableId targetTableId;
    private ColumnLocalId targetColumnId;

    public ColumnScopedInvocationCreator(OperationDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    public OperationInvocation create() {
        if (this.targetTableId == null) {
            throw new RuntimeException("A target table is required for this descriptor");
        }
        if (this.targetColumnId == null) {
            throw new RuntimeException("A target column is required for this descriptor");
        }
        return new ImmutableOperationInvocation(this.targetTableId, this.targetColumnId, this.descriptor, this.parameters);
    }

    @Override
    public InvocationCreator setTargetTable(TableId tableId) {
        this.targetTableId = tableId;
        return this;
    }

    @Override
    public InvocationCreator setTargetColumn(ColumnLocalId columnId) {
        this.targetColumnId = columnId;
        return this;
    }
}

