package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.gcube.data.analysis.tabulardata.model.table.Table;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class ImmutableWorkerResult implements WorkerResult {

	private Table table;

	private List<Table> collateralTables = new ArrayList<Table>();
	
	@SuppressWarnings("unused")
	private ImmutableWorkerResult() {}

	public ImmutableWorkerResult(Table table) {
		this.table = table;
	}

	public ImmutableWorkerResult(Table table, List<Table> collateralTables) {
		this.table = table;
		this.collateralTables = collateralTables;
	}

	public Table getResultTable() {
		return table;
	}

	public List<Table> getCollateralTables() {
		return collateralTables;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ImmutableWorkerResult [table=");
		builder.append(table);
		builder.append(", collateralTables=");
		builder.append(collateralTables);
		builder.append("]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((collateralTables == null) ? 0 : collateralTables.hashCode());
		result = prime * result + ((table == null) ? 0 : table.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ImmutableWorkerResult other = (ImmutableWorkerResult) obj;
		if (collateralTables == null) {
			if (other.collateralTables != null)
				return false;
		} else if (!collateralTables.equals(other.collateralTables))
			return false;
		if (table == null) {
			if (other.table != null)
				return false;
		} else if (!table.equals(other.table))
			return false;
		return true;
	}

}
