/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.factories.types;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.ImmutableOperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.OperationType;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnMetadataParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ColumnTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextChoiceParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetTableParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

public abstract class BaseWorkerFactory<T extends Worker<?>>
implements WorkerFactory<T> {
    protected abstract String getOperationName();

    protected abstract String getOperationDescription();

    protected OperationId getOperationId() {
        return new OperationId(this.getClass());
    }

    @Override
    public List<WorkerFactory<ValidationWorker>> getPrecoditionValidations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isRollbackable() {
        return false;
    }

    @Override
    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        throw new UnsupportedOperationException();
    }

    protected abstract OperationScope getOperationScope();

    protected abstract OperationType getOperationType();

    @Override
    public OperationDescriptor getOperationDescriptor() {
        return new ImmutableOperationDescriptor(this.getOperationId(), this.getOperationName(), this.getOperationDescription(), this.getOperationScope(), this.getOperationType(), this.getParameters());
    }

    protected abstract List<Parameter> getParameters();

    private void checkParameters(List<Parameter> toCheckParams, Map<String, Object> paramInstances, OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        for (Parameter parameter : toCheckParams) {
            if (paramInstances.containsKey(parameter.getIdentifier()) && paramInstances.get(parameter.getIdentifier()) == null) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is null", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 0 && !paramInstances.containsKey(parameter.getIdentifier())) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s is missing", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMinimum() > 1 && !(paramInstances.get(parameter.getIdentifier()) instanceof Iterable)) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s must be multiple", parameter.getIdentifier()));
            }
            if (parameter.getCardinality().getMaximum() == 1 && paramInstances.get(parameter.getIdentifier()) instanceof Iterable) {
                throw new InvalidInvocationException(invocation, String.format("Parameter %s cannot be multiple", parameter.getIdentifier()));
            }
            Object value = paramInstances.get(parameter.getIdentifier());
            if (value == null) continue;
            if (value instanceof Iterable) {
                for (Object obj : (Iterable)value) {
                    this.checkParameterInstance(obj, parameter, invocation, cubeManager);
                    if (!(parameter instanceof CompositeParameter)) continue;
                    this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)obj, invocation, cubeManager);
                }
                continue;
            }
            this.checkParameterInstance(value, parameter, invocation, cubeManager);
            if (!(parameter instanceof CompositeParameter)) continue;
            this.checkParameters(((CompositeParameter)parameter).getParameters(), (Map)value, invocation, cubeManager);
        }
    }

    private void checkParameterInstance(Object obj, Parameter parameter, OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        block23: {
            if (parameter instanceof LeafParameter) {
                LeafParameter leaf = (LeafParameter)parameter;
                if (!leaf.getParameterType().isAssignableFrom(obj.getClass())) {
                    throw new InvalidInvocationException(invocation, String.format("Invalid %s parameter instance class. Found %s, expected %s ", parameter.getIdentifier(), obj.getClass(), ((LeafParameter)parameter).getParameterType()));
                }
                try {
                    ColumnMetadata meta;
                    ColumnType type;
                    Table table;
                    RegexpStringParameter reg;
                    String param;
                    MultivaluedStringParameter multi;
                    if (leaf instanceof ExpressionParameter && !((ExpressionParameter)leaf).validate((Expression)obj)) {
                        ((Expression)obj).validate();
                    }
                    if (leaf instanceof MultivaluedStringParameter && !(multi = (MultivaluedStringParameter)leaf).validate(param = (String)obj)) {
                        throw new Exception(String.format("Passed argument %s is not among valid ones %s ", param, multi.getAdmittedValues()));
                    }
                    if (leaf instanceof RegexpStringParameter && !(reg = (RegexpStringParameter)leaf).validate(param = (String)obj)) {
                        throw new Exception(String.format("Passed argument %s doesn't match regexp constraint %s", param, reg.getRegexp()));
                    }
                    if (leaf instanceof TargetColumnParameter) {
                        ColumnReference ref = (ColumnReference)obj;
                        param = (TargetColumnParameter)leaf;
                        table = this.getTable(invocation, ref.getTableId(), cubeManager);
                        if (!param.getAllowedTableTypes().contains(table.getTableType())) {
                            throw new Exception(String.format("Invalid table type %s, allowed types are : %s.", table.getTableType().getName(), param.getAllowedTableTypes()));
                        }
                        Column col = this.getColumn(invocation, ref.getColumnId(), table, cubeManager);
                        if (!param.getAllowedColumnTypes().contains(col.getColumnType())) {
                            throw new Exception(String.format("Invalid column type %s, allowed types are : %s.", col.getColumnType().getName(), param.getAllowedColumnTypes()));
                        }
                    }
                    if (leaf instanceof TargetTableParameter) {
                        TableId tableId = (TableId)obj;
                        param = (TargetTableParameter)leaf;
                        table = this.getTable(invocation, tableId, cubeManager);
                        if (!param.getAllowedTableTypes().contains(table.getTableType())) {
                            throw new Exception(String.format("Invalid table type %s, allowed types are : %s.", table.getTableType().getName(), param.getAllowedTableTypes()));
                        }
                    }
                    if (leaf instanceof LocalizedTextChoiceParameter) {
                        ImmutableLocalizedText text = (ImmutableLocalizedText)obj;
                        param = (LocalizedTextChoiceParameter)leaf;
                        if (!param.getLabelChoices().contains(text)) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", text, param.getLabelChoices()));
                        }
                    }
                    if (leaf instanceof ColumnTypeParameter) {
                        type = (ColumnType)obj;
                        param = (ColumnTypeParameter)leaf;
                        if (!param.getAllowedColumnTypes().contains(type)) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", type, param.getAllowedColumnTypes()));
                        }
                    }
                    if (leaf instanceof DataTypeParameter) {
                        type = (DataType)obj;
                        param = (DataTypeParameter)leaf;
                        boolean ok = false;
                        for (DataType allowed : param.getAllowedDataTypes()) {
                            if (!type.getClass().equals(allowed.getClass())) continue;
                            ok = true;
                            break;
                        }
                        if (!ok) {
                            throw new Exception(String.format("Passed argument %s is not among valid ones %s ", type, param.getAllowedDataTypes()));
                        }
                    }
                    if (leaf instanceof ColumnMetadataParameter && !(param = (ColumnMetadataParameter)leaf).isObjectValid((Object)(meta = (ColumnMetadata)obj))) {
                        throw new Exception(String.format("Passed argument %s is not among valid ones %s ", meta, param.getAllowedClasses()));
                    }
                    break block23;
                }
                catch (Exception e) {
                    throw new InvalidInvocationException(invocation, String.format("Parameter %s is invalid. Failure cause : %s ", parameter.getIdentifier(), e.getMessage()));
                }
            }
            if (parameter instanceof CompositeParameter) {
                try {
                    Map map = (Map)obj;
                }
                catch (Exception e) {
                    throw new InvalidInvocationException(invocation, String.format("Parameter %s must implement Map<String,Object>", parameter.getIdentifier()));
                }
            }
        }
    }

    protected void performBaseChecks(OperationInvocation invocation, CubeManager cubeManager) throws InvalidInvocationException {
        if (invocation == null) {
            throw new InvalidInvocationException(invocation, "Operation invocation cannot be null");
        }
        if (invocation.getParameterInstances() == null) {
            throw new InvalidInvocationException(invocation, "Paramater map cannot be null");
        }
        switch (this.getOperationScope()) {
            case COLUMN: {
                Table table = this.getTable(invocation, invocation.getTargetTableId(), cubeManager);
                this.getColumn(invocation, invocation.getTargetColumnId(), table, cubeManager);
                break;
            }
            case TABLE: {
                this.getTable(invocation, invocation.getTargetTableId(), cubeManager);
            }
        }
        this.checkParameters(this.getParameters(), invocation.getParameterInstances(), invocation, cubeManager);
    }

    private Column getColumn(OperationInvocation invocation, ColumnLocalId colId, Table table, CubeManager cubeManager) throws InvalidInvocationException {
        if (colId == null) {
            throw new InvalidInvocationException(invocation, "Column id cannot be null");
        }
        try {
            return table.getColumnById(colId);
        }
        catch (NoSuchColumnException e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    private Table getTable(OperationInvocation invocation, TableId tableId, CubeManager cubeManager) throws InvalidInvocationException {
        if (tableId == null) {
            throw new InvalidInvocationException(invocation, "Table id cannot be null");
        }
        try {
            return cubeManager.getTable(tableId);
        }
        catch (NoSuchTableException e) {
            throw new InvalidInvocationException(invocation, e.getMessage());
        }
    }

    @Override
    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        return this.getOperationDescription();
    }
}

