package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;


public class ImmutableTableResource implements ResourceDescriptorResult{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3369581598451116331L;
	
	private TableResource table;
	private String description;
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	
	public ImmutableTableResource(TableResource table,
			String description) {
		super();
		this.table = table;
		this.description = description;
	}
	
	public ImmutableTableResource(TableResource table, String description,
			ResourceScope resourceScope) {
		super();
		this.table = table;
		this.description = description;
		this.resourceScope = resourceScope;
	}

	@Override
	public TableResource getResource() {
		return table;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}

}
