package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;


public class ImmutableTableResource implements ResourceDescriptorResult{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3369581598451116331L;
	
	private TableResource table;
	private String description;
	private String name;
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	
	public ImmutableTableResource(TableResource table, String name,
			String description) {
		this.table = table;
		this.name = name;
		this.description = description;
	}
	
	public ImmutableTableResource(TableResource table, String name, String description,
			ResourceScope resourceScope) {
		this(table, name, description);
		this.resourceScope = resourceScope;
	}

	@Override
	public TableResource getResource() {
		return table;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}

	@Override
	public String getName() {
		return name;
	}
	
}
