/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.QueryThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProgress {
    private static Logger logger = LoggerFactory.getLogger(QueryProgress.class);
    private DatabaseConnectionProvider connectionProvider;
    private Table table;
    private int countExtimation;
    private QueryThread thread;

    protected QueryProgress(DatabaseConnectionProvider conn, Table table, int countExtimation, QueryThread thread) {
        this.table = table;
        this.countExtimation = countExtimation;
        this.thread = thread;
        this.connectionProvider = conn;
    }

    public float getProgress() throws SQLException, Exception {
        float f;
        if (this.thread.getState() == QueryThread.STATE.FINISHED) {
            return 1.0f;
        }
        if (this.thread.getState() == QueryThread.STATE.STOPPED) {
            throw this.thread.getError();
        }
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(String.format("select last_value-start_value from %s_id_seq ", this.table.getName()));
            rs.next();
            int seqValue = rs.getInt(1);
            float progress = (float)seqValue / (float)this.countExtimation;
            f = progress >= 1.0f ? 0.99f : progress;
        }
        catch (Throwable exception) {
            try {
                throw new Exception("progress can't be calculated", exception);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return f;
    }
}

