/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.comet;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.dbutils.DbUtils;
import org.fao.fi.comet.mapping.model.Mapping;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingDetail;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.metadata.MetadataHolder;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.harmonization.HarmonizationRule;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.HarmonizationRuleHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.comet.model.MappedRow;
import org.gcube.data.analysis.tabulardata.operation.comet.model.MappedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingParser {
    private static Logger logger = LoggerFactory.getLogger(MappingParser.class);
    private ParserConfiguration config;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Map<String, String> columnsMapping = new HashMap<String, String>();
    private long foundMappingsCount = 0L;
    private long parsedRulesCount = 0L;
    private Table rulesTable = null;
    private Connection conn = null;
    private PreparedStatement loadRowFromCurrent = null;
    private PreparedStatement loadRowFromPrevious = null;
    private PreparedStatement insertRuleStmt = null;

    public MappingParser(ParserConfiguration config, SQLExpressionEvaluatorFactory evaluatorFactory, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) throws IOException, JAXBException {
        this.config = config;
        this.evaluatorFactory = evaluatorFactory;
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.analyzeTableStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String xmlFile) throws Exception {
        XMLStreamReader xmler = null;
        try {
            if (this.rulesTable == null) {
                this.rulesTable = HarmonizationRuleHelper.createTable((CubeManager)this.cubeManager);
            }
            logger.debug("Parsing file " + xmlFile);
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            xmler = xmlif.createXMLStreamReader(OperationHelper.getInputStreamFromUrl((String)xmlFile));
            JAXBContext ctxUnmarshall = JAXBContext.newInstance((Class[])new Class[]{MappingData.class});
            MappingData deserialized = (MappingData)ctxUnmarshall.createUnmarshaller().unmarshal(xmler);
            Collection mappings = deserialized.getMappings();
            if (this.conn == null) {
                this.conn = this.connectionProvider.getConnection();
            }
            logger.debug("Parsed {} mappings", (Object)mappings.size());
            this.foundMappingsCount = mappings.size();
            for (Mapping mapping : mappings) {
                try {
                    MappedRow sourceRow = this.loadRow(this.config.getDirection().equals((Object)MappingDirection.FORWARD), mapping.getSource().getId().getElementId().toString());
                    for (MappingDetail targetCandidate : mapping.getTargets()) {
                        if (!(targetCandidate.getScore() >= this.config.getScoreThreshold())) continue;
                        MappedRow targetRow = this.loadRow(this.config.getDirection().equals((Object)MappingDirection.BACKWARD), targetCandidate.getTargetElement().getId().getElementId().toString());
                        List<MappedValue> mappedValueList = this.config.getDirection().equals((Object)MappingDirection.FORWARD) ? this.getChangeSet(sourceRow, targetRow) : this.getChangeSet(targetRow, sourceRow);
                        for (MappedValue mapped : mappedValueList) {
                            HarmonizationRule rule = this.getRule(mapped);
                            this.storeRule(rule);
                            System.out.println(rule);
                            ++this.parsedRulesCount;
                        }
                    }
                }
                catch (Throwable t) {
                    logger.debug("Skipping mapping for source element {} ", (Object)mapping.getSource().getId().getElementId(), (Object)t);
                }
            }
            logger.debug(String.format("Generated %s rules out of %s mappings into %s table.", this.parsedRulesCount, this.foundMappingsCount, this.rulesTable));
        }
        finally {
            if (xmler != null) {
                xmler.close();
            }
            if (this.insertRuleStmt != null) {
                DbUtils.closeQuietly((Statement)this.insertRuleStmt);
            }
            if (this.conn != null) {
                DbUtils.closeQuietly((Connection)this.conn);
            }
        }
    }

    private HarmonizationRule getRule(MappedValue mapped) throws Exception {
        Column referred = this.getConfig().getCurrentCodelistVersion().getColumnByName(mapped.getFieldName());
        TDTypeValue targetValue = referred.getDataType().fromString(mapped.getTargetValue());
        TDTypeValue sourceValue = referred.getDataType().fromString(mapped.getSourceValue());
        return new HarmonizationRule(sourceValue, targetValue, referred.getLocalId(), Boolean.valueOf(true), (String)this.evaluatorFactory.getEvaluator((Expression)sourceValue).evaluate(), (String)this.evaluatorFactory.getEvaluator((Expression)targetValue).evaluate());
    }

    private int storeRule(HarmonizationRule r) throws SQLException, JAXBException {
        if (this.insertRuleStmt == null) {
            String insertStatement = "INSERT INTO " + this.rulesTable.getName() + "(" + "enabled" + "," + "referred_column" + "," + "to_change_value" + "," + "to_change_value_description" + "," + "to_set_value" + "," + "to_set_value_description" + ") VALUES (?,?,?,?,?,?)";
            this.insertRuleStmt = this.conn.prepareStatement(insertStatement);
        }
        Map values = r.asMap();
        this.insertRuleStmt.setBoolean(1, r.isEnabled());
        this.insertRuleStmt.setString(2, (String)values.get("referred_column"));
        this.insertRuleStmt.setString(3, (String)values.get("to_change_value"));
        this.insertRuleStmt.setString(4, r.getToChangeValueDescription());
        this.insertRuleStmt.setString(5, (String)values.get("to_set_value"));
        this.insertRuleStmt.setString(6, r.getToSetValueDescription());
        return this.insertRuleStmt.executeUpdate();
    }

    private List<MappedValue> getChangeSet(MappedRow original, MappedRow newRow) throws Exception {
        ArrayList<MappedValue> toReturn = new ArrayList<MappedValue>();
        for (Map.Entry<String, String> colMapping : this.columnsMapping.entrySet()) {
            String originalValue = (String)original.get(colMapping.getKey());
            String newValue = (String)newRow.get(colMapping.getValue());
            if (originalValue == null || newValue == null || originalValue.equals(newValue)) continue;
            toReturn.add(new MappedValue(originalValue, newValue, colMapping.getValue()));
        }
        return toReturn;
    }

    private MappedRow loadRow(boolean fromPreviousVersion, String code) throws Exception {
        Table codelistTable = null;
        PreparedStatement toUseStmt = null;
        if (fromPreviousVersion) {
            codelistTable = this.config.getPreviousCodelistVersion();
            if (this.loadRowFromPrevious == null) {
                this.loadRowFromPrevious = this.conn.prepareStatement(this.getLoadRowStmt(codelistTable, this.config.getOldCodesColumn().getName()));
            }
            toUseStmt = this.loadRowFromPrevious;
        } else {
            codelistTable = this.config.getCurrentCodelistVersion();
            if (this.loadRowFromCurrent == null) {
                this.loadRowFromCurrent = this.conn.prepareStatement(this.getLoadRowStmt(codelistTable, ((Column)codelistTable.getColumnsByType(new Class[]{CodeColumnType.class}).get(0)).getName()));
            }
            toUseStmt = this.loadRowFromCurrent;
        }
        toUseStmt.setString(1, code);
        ResultSet rs = toUseStmt.executeQuery();
        if (rs.next()) {
            HashMap<String, String> valuesPerField = new HashMap<String, String>();
            List columns = codelistTable.getColumnsExceptTypes(new Class[]{CodeColumnType.class, IdColumnType.class, ValidationColumnType.class});
            for (Column col : columns) {
                ArrayList labels = OperationHelper.getLabels((MetadataHolder)col);
                valuesPerField.put(col.getName(), rs.getString(col.getName()));
            }
            rs.close();
            return new MappedRow(valuesPerField, code);
        }
        throw new Exception("Row with code " + code + " not found");
    }

    private String getLoadRowStmt(Table theCodelist, String codeColumnName) {
        String tableName = theCodelist.getName();
        return String.format("Select * from %s WHERE %s = ?", tableName, codeColumnName);
    }

    public ParserConfiguration getConfig() {
        return this.config;
    }

    public long getParsedRulesCount() {
        return this.parsedRulesCount;
    }

    public long getFoundMappingsCount() {
        return this.foundMappingsCount;
    }

    public Table getRulesTable() {
        return this.rulesTable;
    }

    private void analyzeTableStructure() {
        for (Column previous : this.config.getPreviousCodelistVersion().getColumnsExceptTypes(new Class[]{CodeColumnType.class, IdColumnType.class, ValidationColumnType.class})) {
            ArrayList previousLabels = OperationHelper.getLabels((MetadataHolder)previous);
            block1: for (Column current : this.config.getCurrentCodelistVersion().getColumnsExceptTypes(new Class[]{CodeColumnType.class, IdColumnType.class, ValidationColumnType.class})) {
                if (previous.getName().equals(current.getName()) || previous.getLocalId().equals((Object)current.getLocalId())) {
                    this.columnsMapping.put(previous.getName(), current.getName());
                    continue;
                }
                for (String currentLabel : OperationHelper.getLabels((MetadataHolder)current)) {
                    if (!previousLabels.contains(currentLabel)) continue;
                    this.columnsMapping.put(previous.getName(), current.getName());
                    continue block1;
                }
            }
        }
    }

    public static class ParserConfiguration {
        private Table previousCodelistVersion;
        private Table currentCodelistVersion;
        private Column oldCodesColumn;
        private double scoreThreshold = 1.0;
        private boolean skipOnError = true;
        private MappingDirection direction = MappingDirection.BACKWARD;

        public ParserConfiguration(Table previousCodelistVersion, Table currentCodelistVersion, Column oldCodesColumn) {
            this.previousCodelistVersion = previousCodelistVersion;
            this.currentCodelistVersion = currentCodelistVersion;
            this.oldCodesColumn = oldCodesColumn;
        }

        public Column getOldCodesColumn() {
            return this.oldCodesColumn;
        }

        public Table getCurrentCodelistVersion() {
            return this.currentCodelistVersion;
        }

        public Table getPreviousCodelistVersion() {
            return this.previousCodelistVersion;
        }

        public void setDirection(MappingDirection direction) {
            this.direction = direction;
        }

        public MappingDirection getDirection() {
            return this.direction;
        }

        public boolean isSkipOnError() {
            return this.skipOnError;
        }

        public double getScoreThreshold() {
            return this.scoreThreshold;
        }

        public void setScoreThreshold(double scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public void setSkipOnError(boolean skipOnError) {
            this.skipOnError = skipOnError;
        }
    }

    public static enum MappingDirection {
        FORWARD,
        BACKWARD;

    }
}

