/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnection;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.csv.importer.InitializerProcessor;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVImport
extends DataWorker {
    private static Logger logger = LoggerFactory.getLogger(CSVImport.class);
    private String encoding;
    private Character separator;
    private Boolean hasHeader;
    private String url;
    private List<Boolean> fieldMask;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    public CSVImport(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.retrieveParameters();
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkerResult execute() throws WorkerException {
        logger.trace("starting import CSV");
        Table table = null;
        File csvFile = null;
        InitializerProcessor initializerProcessor = null;
        try {
            this.updateProgress(0.1f, "Downloading csv file");
            try {
                csvFile = this.getInputFile(this.url);
            }
            catch (Exception e) {
                logger.error("failed downloading csv file", (Throwable)e);
                throw new WorkerException("failed downloading csv file", (Throwable)e);
            }
            this.updateProgress(0.3f, "Parsing the file");
            try {
                initializerProcessor = this.getInitializerProcessor(csvFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("failed reading csv header", (Throwable)e);
                throw new WorkerException("failed reading csv header", (Throwable)e);
            }
            this.updateProgress(0.5f, "Creating table");
            try {
                table = this.createTable(initializerProcessor.getColumns());
            }
            catch (Exception e) {
                initializerProcessor.getOutputFile().delete();
                logger.error("failed creating table", (Throwable)e);
                throw new WorkerException("failed creating table", (Throwable)e);
            }
            this.updateProgress(0.6f, "Copying data to table");
            try {
                this.copy(initializerProcessor.getOutputFile(), table);
            }
            catch (Exception e) {
                logger.error("failed copying lines to table", (Throwable)e);
                if (table != null) {
                    this.cubeManager.removeTable(table.getId());
                }
                throw new WorkerException("failed copying lines to table", (Throwable)e);
            }
        }
        finally {
            if (initializerProcessor != null && initializerProcessor.getOutputFile() != null) {
                try {
                    initializerProcessor.getOutputFile().delete();
                }
                catch (Exception e) {
                    logger.warn("temporary file (%s) not deleted, check the temp dir", (Object)initializerProcessor.getOutputFile().getName(), (Object)e);
                }
            }
            if (csvFile != null) {
                try {
                    csvFile.delete();
                }
                catch (Exception e) {
                    logger.warn("temporary file (%s) not deleted, check the temp dir", (Object)csvFile.getName(), (Object)e);
                }
            }
        }
        logger.trace("import CSV finished");
        return new ImmutableWorkerResult(table);
    }

    private Table createTable(List<Column> columns) throws Exception {
        TableCreator tableCreator = this.cubeManager.createTable((TableType)new GenericTableType());
        for (Column column : columns) {
            tableCreator.addColumn(column);
        }
        return tableCreator.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitializerProcessor getInitializerProcessor(File csvFile) throws Exception {
        InitializerProcessor initializer = new InitializerProcessor(this.fieldMask);
        CSVReaderProcessor csvReaderProcessor = new CSVReaderProcessor();
        csvReaderProcessor.setDelimiter(this.separator.charValue());
        csvReaderProcessor.setHasHeader(this.hasHeader.booleanValue());
        InputStreamReader isrInitializer = null;
        try {
            isrInitializer = new InputStreamReader((InputStream)new FileInputStream(csvFile), this.encoding);
            csvReaderProcessor.processStream((Reader)isrInitializer, (CSVLineProcessor)initializer);
            InitializerProcessor initializerProcessor = initializer;
            return initializerProcessor;
        }
        finally {
            if (isrInitializer != null) {
                isrInitializer.close();
            }
            if (initializer != null) {
                initializer.close();
            }
        }
    }

    private File getInputFile(String storageUrl) throws Exception {
        InputStream inputStream = this.getInputStreamFromUrl(storageUrl);
        if (inputStream == null) {
            throw new MalformedURLException();
        }
        File tempFile = File.createTempFile("import", ".csv");
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        int read = 0;
        byte[] bytes = new byte[1024];
        while ((read = inputStream.read(bytes)) != -1) {
            ((OutputStream)outputStream).write(bytes, 0, read);
        }
        ((OutputStream)outputStream).close();
        inputStream.close();
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copy(File csvFile, Table table) throws Exception {
        PGConnection conn = this.connectionProvider.getPostgreSQLConnection();
        CopyManager cpManager = conn.getCopyAPI();
        StringBuilder columns = new StringBuilder();
        for (Column c : table.getColumns()) {
            if (c.getColumnType() instanceof IdColumnType) continue;
            columns.append(c.getName()).append(",");
        }
        columns.deleteCharAt(columns.length() - 1);
        String sqlCmd = String.format("COPY %s ( %s ) FROM STDIN ( FORMAT CSV ,DELIMITER ',', HEADER %b, ENCODING 'UTF-8');", table.getName(), columns.toString(), false);
        logger.info("executing copy for csv import with query {}", (Object)sqlCmd);
        try (InputStreamReader inputStreamReader = null;){
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8");
            long lines = cpManager.copyIn(sqlCmd, (Reader)inputStreamReader);
            inputStreamReader.close();
            long l = lines;
            return l;
        }
    }

    private void retrieveParameters() {
        Map parameters = this.getSourceInvocation().getParameterInstances();
        this.url = (String)parameters.get("url");
        this.separator = Character.valueOf(((String)parameters.get("separator")).charAt(0));
        this.hasHeader = (Boolean)parameters.get("hasHeader");
        this.encoding = (String)parameters.get("encoding");
        this.fieldMask = (List)parameters.get("fieldMask");
    }

    private InputStream getInputStreamFromUrl(String url) throws Exception {
        InputStream inputStream;
        try {
            inputStream = URI.create(url).toURL().openStream();
        }
        catch (MalformedURLException mue) {
            inputStream = new URL(null, url.toString(), new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    System.out.println("is smp url");
                    return new SMPURLConnection(url);
                }
            }).openStream();
        }
        return inputStream;
    }
}

