/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.export.json;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.export.StorageResourceRemoverWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.export.json.JSONExport;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.BooleanParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.RegexpStringParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;

public class JSONExportFactory
extends StorageResourceRemoverWorkerFactory {
    private static final String OPERATION_NAME = "JSON Export";
    private static final OperationId OPERATION_ID = new OperationId(301L);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private static RegexpStringParameter columnsParameter = new RegexpStringParameter("columns", "Columns", "Selected Columns", new Cardinality(1, Integer.MAX_VALUE), ".*");
    private static BooleanParameter viewExportParameter = new BooleanParameter("useView", "View Columns", "export the related view column", Cardinality.OPTIONAL);

    @Inject
    public JSONExportFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        if (cubeManager == null) {
            throw new IllegalArgumentException("cubeManager cannot be null");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("connectionProvider cannot be null");
        }
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public ResourceCreatorWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new JSONExport(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }

    protected String getOperationDescription() {
        return "Export a table to a JSON file";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<Parameter> getParameters() {
        ArrayList parameters = Lists.newArrayList();
        Collections.addAll(parameters, columnsParameter, viewExportParameter);
        return parameters;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        return this.getOperationDescription();
    }
}

