/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.ExtractCodelist;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ExportWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class ExtractCodelistFactory
extends ExportWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3006L);
    public static TargetColumnParameter VALUES_SOURCE_COLUMN;
    public static TargetColumnParameter TARGET_CODE_COLUMN;
    private List<Parameter> parameters = Arrays.asList(VALUES_SOURCE_COLUMN, TARGET_CODE_COLUMN);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;

    static {
        ArrayList<Object> sourceTables = new ArrayList<Object>();
        sourceTables.add(new CodelistTableType());
        sourceTables.add(new DatasetTableType());
        sourceTables.add(new DatasetViewTableType());
        sourceTables.add(new GenericTableType());
        ArrayList<Object> sourceCols = new ArrayList<Object>();
        sourceCols.add(new AnnotationColumnType());
        sourceCols.add(new AttributeColumnType());
        sourceCols.add(new CodeDescriptionColumnType());
        sourceCols.add(new CodeNameColumnType());
        sourceCols.add(new MeasureColumnType());
        VALUES_SOURCE_COLUMN = new TargetColumnParameter("value_source_column", "Values suorce column", "The column from which the codes are taken", Cardinality.ONE, sourceTables, sourceCols);
        ArrayList<CodelistTableType> targetTables = new ArrayList<CodelistTableType>();
        targetTables.add(new CodelistTableType());
        ArrayList<CodeColumnType> targetCols = new ArrayList<CodeColumnType>();
        targetCols.add(new CodeColumnType());
        TARGET_CODE_COLUMN = new TargetColumnParameter("target_code_column", "Target code column", "The code column to which exctracted values must be added", Cardinality.OPTIONAL, targetTables, targetCols);
    }

    @Inject
    public ExtractCodelistFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
    }

    protected String getOperationDescription() {
        return "Extract distinct values from the target column and puts them in the selected codelist or a new one.";
    }

    protected String getOperationName() {
        return "Extract codelist";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return this.parameters;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkParametersValidity(invocation);
        return new ExtractCodelist(invocation, this.cubeManager, this.connectionProvider);
    }

    private void checkParametersValidity(OperationInvocation invocation) throws InvalidInvocationException {
        ColumnReference ref = (ColumnReference)invocation.getParameterInstances().get(VALUES_SOURCE_COLUMN.getIdentifier());
        if (!ref.getTableId().equals((Object)invocation.getTargetTableId())) {
            throw new InvalidInvocationException(invocation, "Source column must belong to target table");
        }
    }
}

