/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.add.UnionFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class UnionWorker
extends Worker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private Table targetTable = null;
    private Table sourceTable = null;
    private Table resultTable = null;
    private Table diffTable = null;
    private Map<Column, Column> colMappings = new HashMap<Column, Column>();
    private String insertQuery = null;
    private String defaultsQuery = null;

    public UnionWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.init();
        this.updateProgress(0.1f, "Initialized process");
        this.resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.diffTable = this.cubeManager.createTable((TableType)new GenericTableType()).create();
        this.updateProgress(0.5f, "Importing data");
        this.formQueries();
        try {
            SQLHelper.executeSQLCommand((String)this.insertQuery, (DatabaseConnectionProvider)this.connectionProvider);
            this.updateProgress(0.8f, "Finalizing data");
            if (this.defaultsQuery != null) {
                SQLHelper.executeSQLCommand((String)this.defaultsQuery, (DatabaseConnectionProvider)this.connectionProvider);
            }
            this.updateProgress(0.9f, "Completing");
            return new ImmutableWorkerResult(this.resultTable, this.diffTable);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to execute queries", (Throwable)e);
        }
    }

    private void init() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        List<Map<String, Object>> mappings = UnionFactory.getMappings(this.getSourceInvocation());
        for (Map<String, Object> mapping : mappings) {
            ColumnReference sourceRef = (ColumnReference)mapping.get(UnionFactory.SOURCE_COLUMN_PARAMETER.getIdentifier());
            if (this.sourceTable == null) {
                this.sourceTable = this.cubeManager.getTable(sourceRef.getTableId());
            }
            ColumnReference targetRef = (ColumnReference)mapping.get(UnionFactory.TARGET_COLUMN_PARAMETER.getIdentifier());
            Column sourceCol = this.sourceTable.getColumnById(sourceRef.getColumnId());
            Column targetCol = this.targetTable.getColumnById(targetRef.getColumnId());
            this.colMappings.put(targetCol, sourceCol);
        }
    }

    private void formQueries() {
        StringBuilder castedSelection = new StringBuilder();
        for (Map.Entry<Column, Column> mapping : this.colMappings.entrySet()) {
            DataType targetDataType = mapping.getKey().getDataType();
            castedSelection.append(String.valueOf((String)this.evaluatorFactory.getEvaluator((Expression)new Cast((Expression)this.sourceTable.getColumnReference(mapping.getValue()), targetDataType)).evaluate()) + ",");
        }
        castedSelection.deleteCharAt(castedSelection.lastIndexOf(","));
        this.insertQuery = String.format("WITH inserted AS (INSERT INTO %s(%s) SELECT %s from %s RETURNING *) INSERT INTO %s(id) SELECT id from inserted", this.resultTable.getName(), OperationHelper.getColumnNamesSnippet(this.colMappings.keySet()), castedSelection.toString(), this.sourceTable.getName(), this.diffTable.getName());
        StringBuilder defaultValuesSnippet = new StringBuilder();
        boolean setDefaults = false;
        for (Column col : this.resultTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (this.colMappings.containsKey(col)) continue;
            setDefaults = true;
            String defaultValue = (String)this.evaluatorFactory.getEvaluator((Expression)col.getDataType().getDefaultValue()).evaluate();
            defaultValuesSnippet.append(String.valueOf(col.getName()) + " = " + defaultValue + ",");
        }
        defaultValuesSnippet.deleteCharAt(defaultValuesSnippet.lastIndexOf(","));
        if (setDefaults) {
            this.defaultsQuery = String.format("UPDATE %s set %s where id IN (SELECT id from %s)", this.resultTable.getName(), defaultValuesSnippet, this.diffTable.getName());
        }
    }
}

