/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.logical.IsNull;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.ExtractCodelistFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class ExtractCodelist
extends DataWorker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;
    private Table sourceTable;
    private Table targetCodelist;
    private Map<ColumnReference, ExtractCodelistFactory.ColumnMapping> declaredMapping;
    private Map<Column, Column> effectiveMapping;

    public ExtractCodelist(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Initializing");
        this.initialize();
        this.updateProgress(0.2f, "Preparing destination codelist");
        this.prepareCodelist();
        this.updateProgress(0.5f, "Inserting values into codelist");
        this.insertData();
        return new ImmutableWorkerResult(this.sourceTable, Collections.singletonList(this.targetCodelist));
    }

    private void initialize() throws WorkerException {
        this.sourceTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        try {
            this.declaredMapping = ExtractCodelistFactory.getMapping(this.getSourceInvocation());
            this.effectiveMapping = new HashMap<Column, Column>(this.declaredMapping.size());
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Invalid invocation", (Throwable)e);
        }
    }

    private void prepareCodelist() {
        ArrayList<Column> additionalColumns = new ArrayList<Column>();
        for (Map.Entry<ColumnReference, ExtractCodelistFactory.ColumnMapping> entry : this.declaredMapping.entrySet()) {
            ExtractCodelistFactory.ColumnMapping mapping = entry.getValue();
            Column targetColumn = null;
            if (mapping.isCreateNewColumn()) {
                targetColumn = BaseColumnFactory.getFactory((ColumnType)mapping.getColumnType()).create(mapping.getDefaultValue().getReturnedDataType());
                if (mapping.getColumnMetadata().size() > 0) {
                    ArrayList<ColumnMetadata> existing = new ArrayList<ColumnMetadata>(targetColumn.getAllMetadata());
                    existing.addAll(mapping.getColumnMetadata());
                    targetColumn.setAllMetadata(existing);
                }
                additionalColumns.add(targetColumn);
                this.effectiveMapping.put(this.sourceTable.getColumnById(entry.getKey().getColumnId()), targetColumn);
                continue;
            }
            if (this.targetCodelist != null) continue;
            this.targetCodelist = this.cubeManager.getTable(entry.getValue().getTargetColumn().getTableId());
        }
        if (this.targetCodelist == null) {
            this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).addColumns(additionalColumns.toArray(new Column[additionalColumns.size()])).create();
        } else {
            Table declaredTargetCodelist = this.targetCodelist;
            this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(this.targetCodelist, true).addColumns(additionalColumns.toArray(new Column[additionalColumns.size()])).create();
            for (Map.Entry<ColumnReference, ExtractCodelistFactory.ColumnMapping> entry : this.declaredMapping.entrySet()) {
                if (entry.getValue().isCreateNewColumn()) continue;
                Column declaredColumn = declaredTargetCodelist.getColumnById(entry.getValue().getTargetColumn().getColumnId());
                Column targetColumn = this.targetCodelist.getColumnByName(declaredColumn.getName());
                this.effectiveMapping.put(this.sourceTable.getColumnById(entry.getKey().getColumnId()), targetColumn);
            }
        }
    }

    private void insertData() throws WorkerException {
        boolean createCodes = true;
        ArrayList<Column> sourceColumns = new ArrayList<Column>(this.effectiveMapping.size());
        ArrayList<Column> targetColumns = new ArrayList<Column>(this.effectiveMapping.size());
        StringBuilder sourceTableAsSnippet = new StringBuilder();
        StringBuilder joinCondition = new StringBuilder();
        for (Map.Entry<Column, Column> entry : this.effectiveMapping.entrySet()) {
            sourceColumns.add(entry.getKey());
            targetColumns.add(entry.getValue());
            if (createCodes && entry.getValue().getColumnType().equals((Object)new CodeColumnType())) {
                createCodes = false;
            }
            sourceTableAsSnippet.append(entry.getKey().getName() + " AS " + entry.getValue().getName() + ",");
            joinCondition.append(entry.getKey().getName() + " = " + entry.getValue().getName() + " - ");
        }
        sourceTableAsSnippet.deleteCharAt(sourceTableAsSnippet.lastIndexOf(","));
        joinCondition.deleteCharAt(joinCondition.lastIndexOf("-"));
        String sqlCommand = String.format("INSERT INTO %1$s (%2$s)(SELECT DISTINCT ON (%3$s) %4$s FROM %5$s AS S LEFT JOIN %1$s as T ON (%6$s) WHERE T.id IS NULL)", this.targetCodelist.getName(), OperationHelper.getColumnNamesSnippet(targetColumns), OperationHelper.getColumnNamesSnippet(sourceColumns), sourceTableAsSnippet, this.sourceTable.getName(), joinCondition.toString().replaceAll("-", "AND"));
        try {
            SQLHelper.executeSQLCommand((String)sqlCommand, (DatabaseConnectionProvider)this.connectionProvider);
            if (createCodes) {
                Column attribute = new AttributeColumnFactory().create((DataType)new BooleanType(), Collections.singletonList(new ImmutableLocalizedText("Suggested Code")));
                this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(this.targetCodelist, true).addColumn(attribute).create();
                Column codeColumn = (Column)this.targetCodelist.getColumnsByType(new Class[]{CodeColumnType.class}).get(0);
                IsNull condition = new IsNull((Expression)this.targetCodelist.getColumnReference(codeColumn));
                String initAttribute = String.format("UPDATE %s SET %s=false", this.targetCodelist.getName(), attribute.getName());
                SQLHelper.executeSQLCommand((String)initAttribute, (DatabaseConnectionProvider)this.connectionProvider);
                String updateCmd = String.format("UPDATE %s SET %s=id,%s=true WHERE %s", this.targetCodelist.getName(), codeColumn.getName(), attribute.getName(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)condition).evaluate());
                SQLHelper.executeSQLCommand((String)updateCmd, (DatabaseConnectionProvider)this.connectionProvider);
            }
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while performing insert query", (Throwable)e);
        }
    }
}

