/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.aggregation.Sum;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.MeasureColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.DenormalizationFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class DenormalizationWorker
extends DataWorker {
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private DatabaseConnectionProvider connProvider;
    private Table targetTable;
    private Table newTable;
    private Column valueColumn;
    private Column attributeColumn;
    private ArrayList<String> values = new ArrayList();
    private HashMap<String, Column> newColumnsByValue = new HashMap();

    public DenormalizationWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, SQLExpressionEvaluatorFactory evaluatorFactory, DatabaseConnectionProvider connProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.evaluatorFactory = evaluatorFactory;
        this.connProvider = connProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.init();
        this.updateProgress(0.1f, String.format("Getting values in ", OperationHelper.retrieveColumnLabel((Column)this.attributeColumn)));
        this.getAttributeValues();
        this.updateProgress(0.2f, "Forming new table structure");
        this.createTable();
        this.updateProgress(0.3f, "Transforming table...");
        this.executeScripts();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.newTable);
    }

    private void init() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.valueColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)DenormalizationFactory.VALUE_COLUMN, (OperationInvocation)this.getSourceInvocation())).getColumnId());
        this.attributeColumn = this.targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)DenormalizationFactory.ATTRIBUTE_COLUMN, (OperationInvocation)this.getSourceInvocation())).getColumnId());
    }

    private void getAttributeValues() throws WorkerException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                conn = this.connProvider.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(String.format("SELECT DISTINCT(%s) FROM %s", this.attributeColumn.getName(), this.targetTable.getName()));
                while (rs.next()) {
                    this.values.add(rs.getObject(1).toString());
                }
            }
            catch (Exception e) {
                throw new WorkerException("Unable to anlyze attribute column", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(stmt);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
    }

    private void createTable() {
        MeasureColumnFactory factory = new MeasureColumnFactory();
        for (String value : this.values) {
            Column toAdd = factory.create((LocalizedText)new ImmutableLocalizedText(value), this.valueColumn.getDataType());
            this.newColumnsByValue.put(value, toAdd);
        }
        TableCreator creator = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, false).removeColumn(this.valueColumn).removeColumn(this.attributeColumn);
        for (Column toAdd : this.newColumnsByValue.values()) {
            creator.addColumn(toAdd);
        }
        this.newTable = creator.create();
    }

    private void executeScripts() throws WorkerException {
        ArrayList<String> scripts = this.getScripts();
        try {
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connProvider, (String[])scripts.toArray(new String[scripts.size()]));
        }
        catch (Exception e) {
            throw new WorkerException("Unable to execute transformation scripts", (Throwable)e);
        }
    }

    private ArrayList<String> getScripts() {
        String aggregationExpression = (String)this.evaluatorFactory.getEvaluator((Expression)new Sum((Expression)this.targetTable.getColumnReference(this.valueColumn))).evaluate();
        StringBuilder existingCondition = new StringBuilder();
        StringBuilder rValues = new StringBuilder();
        ArrayList<Column> toGroupByColumns = new ArrayList<Column>();
        ArrayList<Column> groupedColumns = new ArrayList<Column>();
        for (Column col : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class, ValidationColumnType.class})) {
            if (col.getLocalId().equals((Object)this.attributeColumn.getLocalId()) || col.getLocalId().equals((Object)this.valueColumn.getLocalId())) continue;
            Column newColumn = this.newTable.getColumnById(col.getLocalId());
            toGroupByColumns.add(col);
            groupedColumns.add(newColumn);
            existingCondition.append(String.valueOf(newColumn.getName()) + "=" + "r." + newColumn.getName() + ",");
            rValues.append("r." + newColumn.getName() + ",");
        }
        existingCondition.deleteCharAt(existingCondition.lastIndexOf(","));
        rValues.deleteCharAt(rValues.lastIndexOf(","));
        String sourceColSnippet = OperationHelper.getColumnNamesSnippet(toGroupByColumns);
        String targetColSnippet = OperationHelper.getColumnNamesSnippet(groupedColumns);
        ArrayList<String> scripts = new ArrayList<String>();
        for (Map.Entry<String, Column> entry : this.newColumnsByValue.entrySet()) {
            String attCondition = (String)this.evaluatorFactory.getEvaluator((Expression)new Equals((Expression)this.targetTable.getColumnReference(this.attributeColumn), (Expression)new Cast((Expression)new TDText(entry.getKey()), this.attributeColumn.getDataType()))).evaluate();
            String columnName = entry.getValue().getName();
            scripts.add("DO $$DECLARE r record;BEGIN\tFOR r in Select " + sourceColSnippet + ", " + aggregationExpression + " as agg from " + this.targetTable.getName() + " WHERE " + attCondition + " GROUP BY " + sourceColSnippet + "\tLOOP " + " \t\tIF EXISTS (SELECT * FROM " + this.newTable.getName() + " WHERE " + existingCondition + ")" + " \t\tTHEN UPDATE " + this.newTable.getName() + " SET " + columnName + " = r.agg WHERE " + existingCondition + ";" + " \t\tELSE INSERT INTO " + this.newTable.getName() + " (" + targetColSnippet + "," + columnName + ") VALUES (" + rValues + ", r.agg);" + " \t\tEND IF;" + "\tEND LOOP;" + "END$$");
        }
        return scripts;
    }
}

