/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import java.sql.SQLException;
import java.util.HashSet;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceByExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceByExpression
extends DataWorker {
    private static final Logger log = LoggerFactory.getLogger(ReplaceByExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private Table targetTable;
    private Column targetColumn;
    private Expression condition;
    private Expression value;
    private Table newTable;
    private Table diffTable;

    public ReplaceByExpression(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        this.instantiateExecutionVariables();
        this.updateProgress(0.1f, "Initializing");
        this.diffTable = this.cubeManager.createTable(this.targetTable.getTableType()).addColumn(this.targetColumn).create();
        this.newTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true).create();
        this.updateProgress(0.5f, "Updating");
        this.executeBatch();
        this.updateProgress(0.9f, "Finalizing");
        return new ImmutableWorkerResult(this.newTable, this.diffTable);
    }

    private void instantiateExecutionVariables() throws WorkerException {
        OperationInvocation invocation = this.getSourceInvocation();
        this.targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
        this.condition = (Expression)invocation.getParameterInstances().get(ReplaceByExpressionFactory.CONDITION_PARAMETER.getIdentifier());
        this.value = (Expression)invocation.getParameterInstances().get(ReplaceByExpressionFactory.VALUE_PARAMETER.getIdentifier());
    }

    private String getUpdateStatement() throws WorkerException {
        try {
            Expression actualCondition = this.updateTableReferences(this.condition);
            Expression actualValue = this.updateTableReferences(this.value);
            TableReferenceReplacer actualConditionReferenceReplacer = new TableReferenceReplacer(actualCondition);
            TableReferenceReplacer actualValueReferenceReplacer = new TableReferenceReplacer(actualValue);
            HashSet usedIds = new HashSet(actualConditionReferenceReplacer.getTableIds());
            usedIds.addAll(actualValueReferenceReplacer.getTableIds());
            usedIds.remove(this.newTable.getId());
            StringBuilder fromClause = new StringBuilder();
            if (usedIds.size() > 0) {
                fromClause.append(" FROM ");
                for (TableId tableToUse : usedIds) {
                    fromClause.append(this.cubeManager.getTable(tableToUse).getName()).append(",");
                }
                fromClause.deleteCharAt(fromClause.lastIndexOf(","));
            }
            for (TableId id : actualValueReferenceReplacer.getTableIds()) {
                for (ColumnReference reference : actualValueReferenceReplacer.getReferences(id)) {
                    Table tab = this.cubeManager.getTable(reference.getTableId());
                    DataType type = tab.getColumnById(reference.getColumnId()).getDataType();
                    actualValueReferenceReplacer.replaceColumnReference(reference, new ColumnReference(reference.getTableId(), reference.getColumnId(), type));
                }
            }
            try {
                actualValueReferenceReplacer.getExpression().getReturnedDataType();
                Cast cast = new Cast(actualValueReferenceReplacer.getExpression(), this.targetColumn.getDataType());
                actualValue = cast;
            }
            catch (NotEvaluableDataTypeException ee) {
                log.warn("return type for value not evaluable, continuing with uncasted expression");
                throw new WorkerException(ee.getMessage(), (Throwable)ee);
            }
            String stmt = String.format("WITH updated AS (UPDATE %1$s SET %2$s = %3$s %7$s WHERE %4$s RETURNING %1$s.id)  INSERT INTO %5$s (id, %2$s) SELECT target.id, target.%2$s FROM %6$s as target, updated WHERE updated.id = target.id ", this.newTable.getName(), this.targetColumn.getName(), this.sqlEvaluatorFactory.getEvaluator(actualValue).evaluate(), this.sqlEvaluatorFactory.getEvaluator(actualCondition).evaluate(), this.diffTable.getName(), this.targetTable.getName(), fromClause.toString());
            log.debug("To execute statement : " + stmt);
            return stmt;
        }
        catch (MalformedExpressionException e) {
            throw new WorkerException("Expression is not well formed", (Throwable)e);
        }
        catch (EvaluatorException e) {
            throw new WorkerException("Unable to evaluate expression", (Throwable)e);
        }
    }

    private void executeBatch() throws WorkerException, OperationAbortedException {
        try {
            this.checkAborted();
            SQLHelper.executeSQLBatchCommands((DatabaseConnectionProvider)this.connectionProvider, (String[])new String[]{this.getUpdateStatement()});
        }
        catch (SQLException e) {
            throw new WorkerException("Error occurred while executing SQL command", (Throwable)e);
        }
    }

    private Expression updateTableReferences(Expression e) throws MalformedExpressionException {
        TableReferenceReplacer replacer = new TableReferenceReplacer(e);
        for (ColumnReference original : replacer.getReferences(this.targetTable.getId())) {
            String columnName = this.targetTable.getColumnById(original.getColumnId()).getName();
            replacer.replaceColumnReference(original, this.newTable.getColumnReference(this.newTable.getColumnByName(columnName)));
        }
        return replacer.getExpression();
    }
}

