/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.expression.logical.IsNull;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.AnnotationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeNameColumnFactory;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.resources.ResourceType;
import org.gcube.data.analysis.tabulardata.model.resources.TableResource;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.ExtractCodelistFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ResourcesResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableTableResource;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;

public class ExtractCodelist
extends ResourceCreatorWorker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory;
    private Table sourceTable;
    private Table targetCodelist;
    private Map<ColumnReference, ExtractCodelistFactory.ColumnMapping> declaredMapping;
    private Map<Column, Column> effectiveMapping;

    public ExtractCodelist(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlExpressionEvaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlExpressionEvaluatorFactory = sqlExpressionEvaluatorFactory;
    }

    protected ResourcesResult execute() throws WorkerException, OperationAbortedException {
        this.updateProgress(0.1f, "Initializing");
        this.initialize();
        this.checkAborted();
        this.updateProgress(0.2f, "Preparing destination codelist");
        this.prepareCodelist();
        this.checkAborted();
        this.updateProgress(0.5f, "Inserting values into codelist");
        this.insertData();
        this.checkAborted();
        String resourceName = this.getSourceInvocation().getParameterInstances().containsKey(ExtractCodelistFactory.NAME_PARAMETER.getIdentifier()) ? (String)this.getSourceInvocation().getParameterInstances().get(ExtractCodelistFactory.NAME_PARAMETER.getIdentifier()) : null;
        return new ResourcesResult((ResourceDescriptorResult)new ImmutableTableResource(new TableResource(this.targetCodelist.getId()), resourceName, "codelist created with Extract operation", ResourceType.CODELIST));
    }

    private void initialize() throws WorkerException {
        this.sourceTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        try {
            this.declaredMapping = ExtractCodelistFactory.getMapping(this.getSourceInvocation());
            this.effectiveMapping = new HashMap<Column, Column>(this.declaredMapping.size());
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Invalid invocation", (Throwable)e);
        }
    }

    private void prepareCodelist() throws OperationAbortedException {
        ArrayList<Column> additionalColumns = new ArrayList<Column>();
        for (Map.Entry<ColumnReference, ExtractCodelistFactory.ColumnMapping> entry : this.declaredMapping.entrySet()) {
            ExtractCodelistFactory.ColumnMapping columnMapping = entry.getValue();
            Column targetColumn = null;
            if (columnMapping.isCreateNewColumn()) {
                targetColumn = BaseColumnFactory.getFactory((ColumnType)columnMapping.getColumnType()).create(columnMapping.getDefaultValue().getReturnedDataType());
                if (columnMapping.getColumnMetadata().size() > 0) {
                    ArrayList<ColumnMetadata> existing = new ArrayList<ColumnMetadata>(targetColumn.getAllMetadata());
                    existing.addAll(columnMapping.getColumnMetadata());
                    targetColumn.setAllMetadata(existing);
                }
                additionalColumns.add(targetColumn);
                this.effectiveMapping.put(this.sourceTable.getColumnById(entry.getKey().getColumnId()), targetColumn);
                continue;
            }
            if (this.targetCodelist != null) continue;
            this.targetCodelist = this.cubeManager.getTable(entry.getValue().getTargetColumn().getTableId());
        }
        this.checkAborted();
        if (this.targetCodelist == null) {
            boolean hasCodeColumn = false;
            for (Column column : additionalColumns) {
                if (!column.getColumnType().equals((Object)new CodeColumnType())) continue;
                hasCodeColumn = true;
                break;
            }
            if (!hasCodeColumn) {
                additionalColumns.add(new CodeColumnFactory().create((LocalizedText)new ImmutableLocalizedText("Code"), (DataType)new TextType()));
            }
            this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).addColumns(additionalColumns.toArray(new Column[additionalColumns.size()])).create();
        } else {
            Table declaredTargetCodelist = this.targetCodelist;
            this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(this.targetCodelist, true).addColumns(additionalColumns.toArray(new Column[additionalColumns.size()])).create();
            for (Map.Entry entry : this.declaredMapping.entrySet()) {
                if (((ExtractCodelistFactory.ColumnMapping)entry.getValue()).isCreateNewColumn()) continue;
                Column declaredColumn = declaredTargetCodelist.getColumnById(((ExtractCodelistFactory.ColumnMapping)entry.getValue()).getTargetColumn().getColumnId());
                Column targetColumn = this.targetCodelist.getColumnByName(declaredColumn.getName());
                this.effectiveMapping.put(this.sourceTable.getColumnById(((ColumnReference)entry.getKey()).getColumnId()), targetColumn);
            }
        }
    }

    private void insertData() throws WorkerException, OperationAbortedException {
        block8: {
            boolean createCodes = true;
            boolean createNames = true;
            ArrayList<Column> sourceColumns = new ArrayList<Column>(this.effectiveMapping.size());
            ArrayList<Column> targetColumns = new ArrayList<Column>(this.effectiveMapping.size());
            StringBuilder sourceTableAsSnippet = new StringBuilder();
            StringBuilder joinCondition = new StringBuilder();
            for (Map.Entry<Column, Column> entry : this.effectiveMapping.entrySet()) {
                sourceColumns.add(entry.getKey());
                targetColumns.add(entry.getValue());
                if (createCodes && entry.getValue().getColumnType().equals((Object)new CodeColumnType())) {
                    createCodes = false;
                }
                if (createNames && entry.getValue().getColumnType().equals((Object)new CodeNameColumnType())) {
                    createNames = false;
                }
                sourceTableAsSnippet.append(entry.getKey().getName() + " AS " + entry.getValue().getName() + ",");
                joinCondition.append(entry.getKey().getName() + " = " + entry.getValue().getName() + " - ");
            }
            sourceTableAsSnippet.deleteCharAt(sourceTableAsSnippet.lastIndexOf(","));
            joinCondition.deleteCharAt(joinCondition.lastIndexOf("-"));
            this.checkAborted();
            String sqlCommand = String.format("INSERT INTO %1$s (%2$s)(SELECT DISTINCT ON (%3$s) %4$s FROM %5$s AS S LEFT JOIN %1$s as T ON (%6$s) WHERE T.id IS NULL)", this.targetCodelist.getName(), OperationHelper.getColumnNamesSnippet(targetColumns), OperationHelper.getColumnNamesSnippet(sourceColumns), sourceTableAsSnippet, this.sourceTable.getName(), joinCondition.toString().replaceAll("-", "AND"));
            try {
                String updateCmd;
                String initAttribute;
                IsNull condition;
                Column annotation;
                SQLHelper.executeSQLCommand((String)sqlCommand, (DatabaseConnectionProvider)this.connectionProvider);
                if (createCodes) {
                    annotation = new AnnotationColumnFactory().create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("Suggested Code")));
                    this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(this.targetCodelist, true).addColumn(annotation).create();
                    Column codeColumn = (Column)this.targetCodelist.getColumnsByType(new Class[]{CodeColumnType.class}).get(0);
                    condition = new IsNull((Expression)this.targetCodelist.getColumnReference(codeColumn));
                    initAttribute = String.format("UPDATE %s SET %s=%s", this.targetCodelist.getName(), annotation.getName(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)new Cast((Expression)new TDBoolean(false), annotation.getDataType())).evaluate());
                    SQLHelper.executeSQLCommand((String)initAttribute, (DatabaseConnectionProvider)this.connectionProvider);
                    this.checkAborted();
                    updateCmd = String.format("UPDATE %s SET %s=id,%s=%s WHERE %s", this.targetCodelist.getName(), codeColumn.getName(), annotation.getName(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)new Cast((Expression)new TDBoolean(true), annotation.getDataType())).evaluate(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)condition).evaluate());
                    SQLHelper.executeSQLCommand((String)updateCmd, (DatabaseConnectionProvider)this.connectionProvider);
                }
                if (!createNames) break block8;
                annotation = new AnnotationColumnFactory().create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("Suggested Name")));
                this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(this.targetCodelist, true).addColumn(annotation).create();
                Column codeNameColumn = null;
                try {
                    codeNameColumn = (Column)this.targetCodelist.getColumnsByType(new Class[]{CodeNameColumnType.class}).get(0);
                }
                catch (IndexOutOfBoundsException e) {
                    codeNameColumn = new CodeNameColumnFactory().create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("Code Name")));
                    this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(this.targetCodelist, true).addColumn(codeNameColumn).create();
                }
                condition = new IsNull((Expression)this.targetCodelist.getColumnReference(codeNameColumn));
                initAttribute = String.format("UPDATE %s SET %s=%s", this.targetCodelist.getName(), annotation.getName(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)new Cast((Expression)new TDBoolean(false), annotation.getDataType())).evaluate());
                SQLHelper.executeSQLCommand((String)initAttribute, (DatabaseConnectionProvider)this.connectionProvider);
                this.checkAborted();
                updateCmd = String.format("UPDATE %s SET %s=id,%s=%s WHERE %s", this.targetCodelist.getName(), codeNameColumn.getName(), annotation.getName(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)new Cast((Expression)new TDBoolean(true), annotation.getDataType())).evaluate(), this.sqlExpressionEvaluatorFactory.getEvaluator((Expression)condition).evaluate());
                SQLHelper.executeSQLCommand((String)updateCmd, (DatabaseConnectionProvider)this.connectionProvider);
            }
            catch (Exception e) {
                throw new WorkerException("Error occurred while performing insert query", (Throwable)e);
            }
        }
    }
}

