/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation.csquare;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.GreaterThan;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Length;
import org.gcube.data.analysis.tabulardata.expression.composite.text.SubstringByIndex;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceByExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.csquare.DownScaleCsquareFactory;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.csquare.Resolution;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationAbortedException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;

public class DownScaleCsquareWorker
extends DataWorker {
    private CubeManager cm;
    private ReplaceByExpressionFactory replaceFactory;
    private DatabaseConnectionProvider connProvider;

    public DownScaleCsquareWorker(OperationInvocation sourceInvocation, CubeManager cm, ReplaceByExpressionFactory replaceFactory, DatabaseConnectionProvider connProvider) {
        super(sourceInvocation);
        this.cm = cm;
        this.replaceFactory = replaceFactory;
        this.connProvider = connProvider;
    }

    protected WorkerResult execute() throws WorkerException, OperationAbortedException {
        try {
            this.updateProgress(0.1f, "Initializing");
            Resolution toSetResolution = DownScaleCsquareFactory.getFinalResolution(this.getSourceInvocation(), this.cm, this.connProvider);
            ColumnReference targetColRef = new ColumnReference(this.getSourceInvocation().getTargetTableId(), this.getSourceInvocation().getTargetColumnId());
            SubstringByIndex toSet = new SubstringByIndex((Expression)targetColRef, (Expression)new TDInteger(Integer.valueOf(1)), (Expression)new TDInteger(toSetResolution.getCsquareLength()));
            this.checkAborted();
            this.updateProgress(0.3f, "Downscaling..");
            WorkerWrapper wrapper = this.createWorkerWrapper((WorkerFactory)this.replaceFactory);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            GreaterThan condition = new GreaterThan((Expression)new Length((Expression)targetColRef), (Expression)new TDInteger(toSetResolution.getCsquareLength()));
            parameters.put(ReplaceByExpressionFactory.CONDITION_PARAMETER.getIdentifier(), condition);
            parameters.put(ReplaceByExpressionFactory.VALUE_PARAMETER.getIdentifier(), toSet);
            this.checkAborted();
            WorkerStatus status = wrapper.execute(this.getSourceInvocation().getTargetTableId(), this.getSourceInvocation().getTargetColumnId(), parameters);
            this.checkAborted();
            this.updateProgress(0.9f, "Finalizing..");
            if (!status.equals((Object)WorkerStatus.SUCCEDED)) {
                throw new Exception("Unexpected internal error on replacing values.");
            }
            return new ImmutableWorkerResult(((WorkerResult)wrapper.getResult()).getResultTable());
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unexpected internal error, unable to modify values", (Throwable)e);
        }
        catch (OperationAbortedException e) {
            throw e;
        }
        catch (WorkerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkerException("Unexpected internal error, unable to modify values", (Throwable)e);
        }
    }
}

