/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.DenormalizationWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;

@Singleton
public class DenormalizationFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3005L);
    public static final int MAX_COLUMN_COUNT = 1600;
    public static TargetColumnParameter VALUE_COLUMN = new TargetColumnParameter("value_column", "Value column", "Values to aggregate", Cardinality.ONE);
    public static TargetColumnParameter ATTRIBUTE_COLUMN = new TargetColumnParameter("attribute_column", "Attribute Column", "Column by which denormalize", Cardinality.ONE);
    public static TargetColumnParameter REFERRED_COLUMN = new TargetColumnParameter("ref_column", "Referred Column", "Labels for the selected dimension", Cardinality.OPTIONAL);
    private static List<Parameter> params = Arrays.asList(VALUE_COLUMN, ATTRIBUTE_COLUMN, REFERRED_COLUMN);
    private CubeManager cubeManager;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private DatabaseConnectionProvider connProvider;

    @Inject
    public DenormalizationFactory(CubeManager cubeManager, SQLExpressionEvaluatorFactory evaluatorFactory, DatabaseConnectionProvider connProvider, ValidateDataWithExpressionFactory validationFactory) {
        this.cubeManager = cubeManager;
        this.evaluatorFactory = evaluatorFactory;
        this.connProvider = connProvider;
    }

    public DataWorker createWorker(OperationInvocation arg0) throws InvalidInvocationException {
        this.performBaseChecks(arg0, this.cubeManager);
        this.performCustomChecks(arg0);
        if (!this.isCountValuesValid(arg0)) {
            throw new InvalidInvocationException(arg0, "Too many distinct values on selected attribute column, couldn't denormalize table (max column count allowed: 1600)");
        }
        return new DenormalizationWorker(arg0, this.cubeManager, this.evaluatorFactory, this.connProvider);
    }

    private boolean isCountValuesValid(OperationInvocation inv) throws InvalidInvocationException {
        Table targetTable = this.cubeManager.getTable(inv.getTargetTableId());
        Column attribute = targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)ATTRIBUTE_COLUMN, (Map)inv.getParameterInstances())).getColumnId());
        try {
            return SQLHelper.getSpecificCount((DatabaseConnectionProvider)this.connProvider, (String)targetTable.getName(), (String)("DISTINCT(" + attribute.getName() + ")"), (String)"true") + targetTable.getColumns().size() < 1600;
        }
        catch (SQLException e) {
            throw new InvalidInvocationException(inv, "Unexpected exception while getting values count", (Exception)e);
        }
    }

    public String describeInvocation(OperationInvocation toDescribeInvocation) throws InvalidInvocationException {
        this.performBaseChecks(toDescribeInvocation, this.cubeManager);
        this.performCustomChecks(toDescribeInvocation);
        Table targetTable = this.cubeManager.getTable(toDescribeInvocation.getTargetTableId());
        return String.format("Denormalize %s by %s.", OperationHelper.retrieveColumnLabel((Column)targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)VALUE_COLUMN, (OperationInvocation)toDescribeInvocation)).getColumnId())), OperationHelper.retrieveColumnLabel((Column)targetTable.getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)ATTRIBUTE_COLUMN, (OperationInvocation)toDescribeInvocation)).getColumnId())));
    }

    private void performCustomChecks(OperationInvocation invocation) throws InvalidInvocationException {
        ColumnReference attributeRef = (ColumnReference)OperationHelper.getParameter((LeafParameter)ATTRIBUTE_COLUMN, (OperationInvocation)invocation);
        if (!attributeRef.getTableId().equals((Object)invocation.getTargetTableId())) {
            throw new InvalidInvocationException(invocation, "Attribute column must belong to target table");
        }
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column attribute = targetTable.getColumnById(attributeRef.getColumnId());
        if ((attribute.getColumnType() instanceof DimensionColumnType || attribute.getColumnType() instanceof TimeDimensionColumnType) && invocation.getParameterInstances().containsKey(REFERRED_COLUMN.getIdentifier()) && !((ColumnReference)OperationHelper.getParameter((LeafParameter)REFERRED_COLUMN, (OperationInvocation)invocation)).getTableId().equals((Object)attribute.getRelationship().getTargetTableId())) {
            throw new InvalidInvocationException(invocation, "Selected referred column must belong to attribute's codelist");
        }
        if (!((ColumnReference)OperationHelper.getParameter((LeafParameter)VALUE_COLUMN, (OperationInvocation)invocation)).getTableId().equals((Object)invocation.getTargetTableId())) {
            throw new InvalidInvocationException(invocation, "Value column must belong to target table");
        }
        DataType quantityDataType = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(((ColumnReference)OperationHelper.getParameter((LeafParameter)VALUE_COLUMN, (OperationInvocation)invocation)).getColumnId()).getDataType();
        if (!(quantityDataType instanceof NumericType) && !(quantityDataType instanceof IntegerType)) {
            throw new InvalidInvocationException(invocation, "Unable to aggregate over " + quantityDataType.getName() + " data type");
        }
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected String getOperationDescription() {
        return "Denormalize a Table";
    }

    protected String getOperationName() {
        return "Denormalization";
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    public Map<String, WorkerFactory<ValidationWorker>> getPreconditionValidationMap() {
        return super.getPreconditionValidationMap();
    }
}

