/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation.csquare;

public enum Resolution {
    TEN("10", 10.0, 4),
    FIVE("5", 5.0, 6),
    ONE("1", 1.0, 8),
    HALF_DEGREE("0.5", 0.5, 10),
    TENTH_DEGREE("0.1", 0.1, 12),
    HALF_TENTH("0.05", 0.05, 14),
    CENTH_DEGREE("0.01", 0.01, 16),
    HALF_CENTH("0.005", 0.005, 18),
    MILLI_DEGREE("0.001", 0.001, 20),
    HALF_MILLI("0.0005", 5.0E-4, 22);

    private final String label;
    private final Double resolution;
    private final Integer csquareLength;

    private Resolution(String label, Double resolution, Integer csquarelength) {
        this.label = label;
        this.resolution = resolution;
        this.csquareLength = csquarelength;
    }

    public String getLabel() {
        return this.label;
    }

    public Double getResolution() {
        return this.resolution;
    }

    public Integer getCsquareLength() {
        return this.csquareLength;
    }

    public static final Resolution fromLabel(String label) {
        Resolution[] resolutionArray = Resolution.values();
        int n = resolutionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution res = resolutionArray[n2];
            if (res.getLabel().equals(label)) {
                return res;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid label " + label);
    }
}

