/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.labels;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.labels.AddColumnName;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.LocalizedTextParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class AddColumnNameFactory
extends ColumnTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1006L);
    CubeManager cubeManager;
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    public static LocalizedTextParameter NAME_LABEL_PARAMETER = new LocalizedTextParameter("NAME_PARAMETER_ID", "Column name", "The column name to set", Cardinality.ONE);

    @Inject
    public AddColumnNameFactory(CubeManager cubeManager) {
        this.cubeManager = cubeManager;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation);
        return new AddColumnName(this.cubeManager, invocation);
    }

    protected String getOperationName() {
        return "Add column name";
    }

    protected String getOperationDescription() {
        return "Add a name label to a column";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    static {
        parameters.add((Parameter)NAME_LABEL_PARAMETER);
    }
}

