/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.labels;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableMetadataWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.labels.AddColumnName;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MapParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;

@Singleton
public class AddColumnNameFactory
extends TableMetadataWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1006L);
    CubeManager cubeManager;
    private static List<Parameter> parameters = new ArrayList<Parameter>();
    public static MapParameter NAME_LABEL_PARAMETER = new MapParameter("NAME_PARAMETER_ID", "mapNameColumns", "The map (ColumnReference -> LocalizedName) to set", Cardinality.ONE, ColumnReference.class, LocalizedText.class);

    @Inject
    public AddColumnNameFactory(CubeManager cubeManager) {
        this.cubeManager = cubeManager;
    }

    public MetadataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new AddColumnName(this.cubeManager, invocation);
    }

    protected String getOperationName() {
        return "Add column name";
    }

    protected String getOperationDescription() {
        return "Add a name label to a column";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Map mapParameter = (Map)OperationHelper.getParameter((LeafParameter)NAME_LABEL_PARAMETER, (OperationInvocation)invocation);
        StringBuilder labelsReport = new StringBuilder();
        for (Map.Entry entry : mapParameter.entrySet()) {
            Column col = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(((ColumnReference)entry.getKey()).getColumnId());
            LocalizedText text = (LocalizedText)entry.getValue();
            labelsReport.append(String.format(" %s [%s] to %s ,", text.getValue(), text.getLocale(), OperationHelper.retrieveColumnLabel((Column)col)));
        }
        labelsReport.deleteCharAt(labelsReport.lastIndexOf(","));
        return String.format("Setting labels: %s", labelsReport.toString());
    }

    static {
        parameters.add((Parameter)NAME_LABEL_PARAMETER);
    }
}

