/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeDataType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.DataTypeParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

@Singleton
public class ChangeDataTypeFactory
extends ColumnTransformationWorkerFactory {
    public static final String DATA_TYPE_ID = "dataType";
    @Inject
    CubeManager cubeManager;
    private static final List<TypeDestinationsSource<? extends DataType>> typeDestinationSources = Lists.newArrayList();

    static {
        typeDestinationSources.add(new BooleanDestinationsSource());
        typeDestinationSources.add(new TextDestionationsSource());
        typeDestinationSources.add(new DateDestinationsSource());
        typeDestinationSources.add(new GeometryDestinationsSource());
        typeDestinationSources.add(new IntegerDestinationsSource());
        typeDestinationSources.add(new NumericDestinationsSource());
    }

    public EligibleOperation getEligibleOperation(TableId tableId, ColumnLocalId columnId) throws OperationNotEligibleException {
        Table table = this.cubeManager.getTable(tableId);
        Column column = table.getColumnById(columnId);
        DataType sourceType = column.getDataType();
        try {
            ArrayList parameters = Lists.newArrayList();
            parameters.add(new DataTypeParameter(DATA_TYPE_ID, "Data type", "The new data type to set", Cardinality.ONE, this.getDataTypeDestinationsFromSourceDataType(sourceType)));
            return new EligibleOperation(this.getOperationDescriptor(), (List)parameters, tableId, columnId);
        }
        catch (Exception e) {
            throw new OperationNotEligibleException(e.getMessage());
        }
    }

    private List<Class<? extends DataType>> getDataTypeDestinationsFromSourceDataType(DataType sourceType) throws Exception {
        for (TypeDestinationsSource<? extends DataType> typeDestinationsSource : typeDestinationSources) {
            if (!sourceType.getClass().equals(typeDestinationsSource.getManagedDataType())) continue;
            return typeDestinationsSource.getDestinationDataTypes();
        }
        throw new Exception("Cannot provide a list of eligible destination data types for the given column type: " + sourceType);
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkTableIdPresence(invocation);
        this.checkColumnIdPresence(invocation);
        this.checkParameterValue(DATA_TYPE_ID, DataType.class, invocation);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
        DataType targetDataType = targetColumn.getDataType();
        return new ChangeDataType(invocation, this.cubeManager, targetTable, targetColumn.getLocalId(), targetDataType);
    }

    protected String getOperationName() {
        return "Change data type";
    }

    protected String getOperationDescription() {
        return "Change the data type for values of a given column";
    }

    private static class BooleanDestinationsSource
    implements TypeDestinationsSource<BooleanType> {
        private static List<Class<? extends DataType>> parameters = Lists.newArrayList();

        static {
            parameters.add(TextType.class);
            parameters.add(BooleanType.class);
        }

        private BooleanDestinationsSource() {
        }

        @Override
        public List<Class<? extends DataType>> getDestinationDataTypes() {
            return parameters;
        }

        @Override
        public Class<BooleanType> getManagedDataType() {
            return BooleanType.class;
        }
    }

    private static class DateDestinationsSource
    implements TypeDestinationsSource<DateType> {
        private static List<Class<? extends DataType>> parameters = Lists.newArrayList();

        static {
            parameters.add(TextType.class);
        }

        private DateDestinationsSource() {
        }

        @Override
        public List<Class<? extends DataType>> getDestinationDataTypes() {
            return parameters;
        }

        @Override
        public Class<DateType> getManagedDataType() {
            return DateType.class;
        }
    }

    private static class GeometryDestinationsSource
    implements TypeDestinationsSource<GeometryType> {
        private static List<Class<? extends DataType>> parameters = Lists.newArrayList();

        static {
            parameters.add(TextType.class);
            parameters.add(GeometryType.class);
        }

        private GeometryDestinationsSource() {
        }

        @Override
        public List<Class<? extends DataType>> getDestinationDataTypes() {
            return parameters;
        }

        @Override
        public Class<GeometryType> getManagedDataType() {
            return GeometryType.class;
        }
    }

    private static class IntegerDestinationsSource
    implements TypeDestinationsSource<IntegerType> {
        private static List<Class<? extends DataType>> parameters = Lists.newArrayList();

        static {
            parameters.add(NumericType.class);
            parameters.add(TextType.class);
        }

        private IntegerDestinationsSource() {
        }

        @Override
        public List<Class<? extends DataType>> getDestinationDataTypes() {
            return parameters;
        }

        @Override
        public Class<IntegerType> getManagedDataType() {
            return IntegerType.class;
        }
    }

    private static class NumericDestinationsSource
    implements TypeDestinationsSource<NumericType> {
        private static List<Class<? extends DataType>> parameters = Lists.newArrayList();

        static {
            parameters.add(IntegerType.class);
            parameters.add(TextType.class);
        }

        private NumericDestinationsSource() {
        }

        @Override
        public List<Class<? extends DataType>> getDestinationDataTypes() {
            return parameters;
        }

        @Override
        public Class<NumericType> getManagedDataType() {
            return NumericType.class;
        }
    }

    private static class TextDestionationsSource
    implements TypeDestinationsSource<TextType> {
        private static List<Class<? extends DataType>> parameters = Lists.newArrayList();

        static {
            parameters.add(TextType.class);
            parameters.add(BooleanType.class);
            parameters.add(DateType.class);
            parameters.add(GeometryType.class);
            parameters.add(IntegerType.class);
            parameters.add(NumericType.class);
        }

        private TextDestionationsSource() {
        }

        @Override
        public List<Class<? extends DataType>> getDestinationDataTypes() {
            return parameters;
        }

        @Override
        public Class<TextType> getManagedDataType() {
            return TextType.class;
        }
    }

    private static interface TypeDestinationsSource<T extends DataType> {
        public List<Class<? extends DataType>> getDestinationDataTypes();

        public Class<T> getManagedDataType();
    }
}

