/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpression;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

@Singleton
public class ValidateDataWithExpressionFactory
extends TableValidatorFactory {
    public static final String EXPRESSION_ID = "expression";
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    @Inject
    public ValidateDataWithExpressionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public EligibleOperation getEligibleOperation(TableId tableId) throws OperationNotEligibleException {
        ArrayList parameters = Lists.newArrayList();
        parameters.add(new ExpressionParameter(EXPRESSION_ID, "Validation statement", "Expression to validate", Cardinality.ONE));
        return new EligibleOperation(this.getOperationDescriptor(), (List)parameters, tableId);
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkTableIdPresence(invocation);
        this.checkParameterValue(EXPRESSION_ID, Expression.class, invocation);
        return new ValidateDataWithExpression(invocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return "Validate table";
    }

    protected String getOperationDescription() {
        return "Validate table data against an expression";
    }
}

