/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.operation.column.typechange.ChangeColumnTypeTransformation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

public class ChangeToAttributeColumn
extends ChangeColumnTypeTransformation {
    private Collection<ColumnMetadata> metadataToSet;

    public ChangeToAttributeColumn(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider databaseConnectionProvider) {
        super(invocation, cubeManager, databaseConnectionProvider);
        this.metadataToSet = this.collectMetadataToSet(invocation);
    }

    @Override
    protected Collection<ColumnMetadata> getMetadataToSet() {
        return this.metadataToSet;
    }

    private Collection<ColumnMetadata> collectMetadataToSet(OperationInvocation invocation) {
        ArrayList result = Lists.newArrayList();
        LocalizedText newLabel = this.retrieveLabelParameter(invocation);
        if (newLabel != null) {
            NamesMetadata oldNamesMeta;
            NamesMetadata namesMeta = new NamesMetadata();
            try {
                oldNamesMeta = (NamesMetadata)this.targetColumn.getMetadata(NamesMetadata.class);
            }
            catch (NoSuchMetadataException e) {
                oldNamesMeta = new NamesMetadata();
            }
            namesMeta.setTexts(oldNamesMeta.getTexts());
            namesMeta.addText(newLabel);
            result.add(namesMeta);
        }
        return result;
    }

    private LocalizedText retrieveLabelParameter(OperationInvocation invocation) {
        return (LocalizedText)invocation.getParameterInstances().get("label");
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return new AttributeColumnType();
    }
}

