/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDatasetView
extends BaseWorker {
    private static final Logger log = LoggerFactory.getLogger(CreateDatasetView.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetDataset;

    public CreateDatasetView(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.targetDataset = cubeManager.getTable(invocation.getTargetTableId());
    }

    public void run() {
        try {
            Table viewTable = this.createDatasetViewTable();
            this.inProgress(0.1f);
            String sql = this.createSQLStatement(viewTable);
            this.inProgress(0.3f);
            this.executeSQLCommand(sql, this.connectionProvider);
            log.trace("Created view table:\n" + viewTable);
            Table resultTable = this.createResultTable(viewTable);
            this.succeed(resultTable);
        }
        catch (OperationException e) {
            this.fail(e);
        }
        catch (Exception e) {
            this.fail(new OperationException("Unable to complete operation", (Throwable)e));
        }
    }

    private Table createResultTable(Table viewTable) {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.targetDataset.getId());
        tmc.setTableMetadata(new TableMetadata[]{new DatasetViewTableMetadata(viewTable.getId())});
        return tmc.create();
    }

    private String createSQLStatement(Table viewTable) {
        Collection<Table> linkedTables = this.collectLinkedTables();
        StringBuilder sqlSelect = new StringBuilder("SELECT ");
        this.appendDatasetColumnNames(sqlSelect);
        this.appendLinkeTableColumnNames(linkedTables, sqlSelect);
        sqlSelect.append("FROM " + this.targetDataset.getName() + " AS d ");
        int i = 0;
        for (TableRelationship rel : this.targetDataset.getRelationships()) {
            Table linkedTable = this.cubeManager.getTable(rel.getTargetTableId());
            String linkedTableAlias = "c" + i;
            String linkedTableName = linkedTable.getName();
            String foreignKeyColumnName = this.targetDataset.getColumnById(rel.getForeignKeyColumnId()).getName();
            String targetIdColumnName = ((Column)linkedTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0)).getName();
            sqlSelect.append(String.format("LEFT JOIN %1$s AS %2$s ON d.%3$s = %2$s.%4$s", linkedTableName, linkedTableAlias, foreignKeyColumnName, targetIdColumnName));
            ++i;
        }
        StringBuilder orderedColumnNames = new StringBuilder();
        for (Column column : viewTable.getColumns()) {
            if (column.getColumnType().equals((Object)new IdColumnType())) continue;
            orderedColumnNames.append(String.valueOf(column.getName()) + " ,");
        }
        orderedColumnNames.deleteCharAt(orderedColumnNames.length() - 1);
        String sqlInsert = String.format("INSERT INTO %s (%s) ", viewTable.getName(), orderedColumnNames);
        String sql = String.valueOf(sqlInsert) + sqlSelect + ";";
        log.trace("Generated \"view filling\" SQL statement:\n" + sql);
        return sql;
    }

    private void appendLinkeTableColumnNames(Collection<Table> linkedTables, StringBuilder sqlSelect) {
        int i = 0;
        for (Table linkedTable : linkedTables) {
            for (Column column : linkedTable.getColumnsByType(new Class[]{CodeColumnType.class, CodeNameColumnType.class, CodeDescriptionColumnType.class})) {
                sqlSelect.append("c" + i + "." + column.getName() + " ,");
            }
            ++i;
        }
        sqlSelect.deleteCharAt(sqlSelect.length() - 1);
    }

    private Collection<Table> collectLinkedTables() {
        ArrayList linkedTables = Lists.newArrayList();
        for (TableRelationship tableRelationship : this.targetDataset.getRelationships()) {
            linkedTables.add(this.cubeManager.getTable(tableRelationship.getTargetTableId()));
        }
        return linkedTables;
    }

    private void appendDatasetColumnNames(StringBuilder sqlSelect) {
        for (Column column : this.targetDataset.getColumns()) {
            if (column.getColumnType().equals((Object)new IdColumnType())) continue;
            sqlSelect.append("d." + column.getName() + " , ");
        }
    }

    private Table createDatasetViewTable() throws OperationException {
        try {
            TableCreator tableCreator = this.cubeManager.createTable((TableType)new DatasetViewTableType());
            tableCreator.like(this.targetDataset, false);
            List dimensionColumns = this.targetDataset.getColumnsByType(new ColumnType[]{new DimensionColumnType(), new TimeDimensionColumnType()});
            for (Column dimensionColumn : dimensionColumns) {
                Table dimensionTable = this.cubeManager.getTable(dimensionColumn.getRelationship().getTargetTableId());
                for (Column column : dimensionTable.getColumnsByType(new Class[]{CodeColumnType.class, CodeNameColumnType.class, CodeDescriptionColumnType.class})) {
                    column.setMetadata((ColumnMetadata)new ViewColumnMetadata(dimensionTable.getId(), column.getLocalId(), dimensionColumn.getLocalId()));
                    tableCreator.addColumn(column);
                }
            }
            Table viewTable = tableCreator.create();
            log.debug("Created view: " + viewTable);
            return viewTable;
        }
        catch (Exception e) {
            throw new OperationException("Unable to create dataset view", (Throwable)e);
        }
    }
}

