package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import java.util.Collection;
import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

import com.google.common.collect.Lists;

public class ChangeToAttributeColumn extends ChangeColumnTypeTransformation {

	private Collection<ColumnMetadata> metadataToSet;

	public ChangeToAttributeColumn(OperationInvocation invocation, CubeManager cubeManager,
			DatabaseConnectionProvider databaseConnectionProvider) {
		super(invocation, cubeManager, databaseConnectionProvider);
		this.metadataToSet = collectMetadataToSet(invocation);
	}

	@Override
	protected Collection<ColumnMetadata> getMetadataToSet() {
		return metadataToSet;
	}

	private Collection<ColumnMetadata> collectMetadataToSet(OperationInvocation invocation) {
		List<ColumnMetadata> result = Lists.newArrayList();

		LocalizedText newLabel = retrieveLabelParameter(invocation);
		if (newLabel != null) {
			NamesMetadata namesMeta = new NamesMetadata();
			NamesMetadata oldNamesMeta;
			try {
				oldNamesMeta = targetColumn.getMetadata(NamesMetadata.class);
			} catch (NoSuchMetadataException e) {
				oldNamesMeta = new NamesMetadata();
			}
			namesMeta.setTexts(oldNamesMeta.getTexts());
			namesMeta.addText(newLabel);
			result.add(namesMeta);
		}

		return result;
	}

	private LocalizedText retrieveLabelParameter(OperationInvocation invocation) {
		return (LocalizedText) invocation.getParameterInstances().get(ChangeToAttributeColumnFactory.LABEL_ID);
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return new AttributeColumnType();
	}

}
