package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

import com.google.common.collect.Lists;

public class ChangeToDimensionColumnFactory extends ColumnTransformationWorkerFactory {

	public static final String REFERENCE_COLUMN_ID = "referenceColumn";
	private static final DimensionColumnType MANAGED_COLUMN_TYPE = new DimensionColumnType();
	private static final List<Class<? extends ColumnType>> allowedSources = Lists.newArrayList();

	static {
		allowedSources.add(AnnotationColumnType.class);
		allowedSources.add(AttributeColumnType.class);
		allowedSources.add(CodeColumnType.class);
		allowedSources.add(CodeNameColumnType.class);
		allowedSources.add(CodeDescriptionColumnType.class);
	}

	//TODO: review
	protected List<Parameter> createParameters(Column targetColumn) {
		List<Parameter> parameters = Lists.newArrayList();
		List<TableType> allowedTableTypes = Lists.newArrayList();
		allowedTableTypes.add(new CodelistTableType());
		List<ColumnType> allowedColumnTypes = Lists.newArrayList();
		allowedColumnTypes.add(new CodeColumnType());
		allowedColumnTypes.add(new CodeNameColumnType());
		allowedColumnTypes.add(new CodeDescriptionColumnType());
		TargetColumnParameter columnParam = new TargetColumnParameter(REFERENCE_COLUMN_ID, "Codelist column", "Reference to a codelist column to link", Cardinality.ONE, allowedTableTypes, allowedColumnTypes);
		parameters.add(columnParam);
		return parameters;
	}





	@Override
	public EligibleOperation getEligibleOperation(TableId tableId, ColumnLocalId columnId)
			throws OperationNotEligibleException {
		// TODO Auto-generated method stub
		return null;
	}





	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		// TODO Auto-generated method stub
		return null;
	}





	@Override
	protected String getOperationName() {
		return "Link a dataset to a codelist";
	}





	@Override
	protected String getOperationDescription() {
		// TODO Auto-generated method stub
		return null;
	}

}
