package org.gcube.data.analysis.tabulardata.operation.table;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

public class ChangeTableType extends BaseWorker {

	private CubeManager cubeManager;
	
	private Table targetTable;
	
	private TableType targetTableType;
	
	public ChangeTableType(OperationInvocation invocation, CubeManager cubeManager, Table targetTable,
			TableType targetTableType) {
		super(invocation);
		this.cubeManager = cubeManager;
		this.targetTable = targetTable;
		this.targetTableType = targetTableType;
	}

	@Override
	public void run() {
		try {
			inProgress(0.1f);
			Table resultTable = cubeManager.createTable(targetTableType).like(targetTable, true).create();
			succeed(resultTable);
		} catch (Exception e) {
			fail(new OperationException("Unable to create table with new table type: " + targetTableType, e));
		}
	}

	
}
