package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

import com.google.common.collect.Lists;

@Singleton
public class ValidateDataWithExpressionFactory extends TableValidatorFactory {

	public static final String EXPRESSION_ID = "expression";
	
	private CubeManager cubeManager;
	private DatabaseConnectionProvider connectionProvider;

	@Inject
	public ValidateDataWithExpressionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}

	@Override
	public EligibleOperation getEligibleOperation(TableId tableId) throws OperationNotEligibleException {
		List<Parameter> parameters = Lists.newArrayList();
		parameters.add(new ExpressionParameter(EXPRESSION_ID, "Validation statement", "Expression to validate",
				Cardinality.ONE));
		return new EligibleOperation(getOperationDescriptor(), parameters, tableId);
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		checkTableIdPresence(invocation);
		checkParameterValue(EXPRESSION_ID, Expression.class, invocation);
		return new ValidateDataWithExpression(invocation, cubeManager, connectionProvider);
	}

	@Override
	protected String getOperationName() {
		return "Validate table";
	}

	@Override
	protected String getOperationDescription() {
		return "Validate table data against an expression";
	}

}
