/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.CubeManagerEvaluatorUtil;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.EvaluatorUtil;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.ValidationColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDataWithExpression
extends BaseWorker {
    private static final Logger log = LoggerFactory.getLogger(ValidateDataWithExpression.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Expression validationExpression;
    private Table newTable;
    private Column validationColumn;
    private Table tempTable;
    private SQLExpressionEvaluatorFactory evaluatorFactory;

    public ValidateDataWithExpression(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.validationExpression = (Expression)invocation.getParameterInstances().get("expression");
        this.evaluatorFactory = new SQLExpressionEvaluatorFactory((EvaluatorUtil)new CubeManagerEvaluatorUtil(cubeManager));
    }

    public void run() {
        String errorMsg = "Unable to complete data validation";
        try {
            this.inProgress(0.1f);
            this.createNewTable();
            this.inProgress(0.4f);
            this.fillValidationColumn();
            this.inProgress(0.7f);
            this.evaluateValidityAndUpdateTableMeta();
            this.succeed(this.newTable);
        }
        catch (OperationException e) {
            log.error(e.getMessage());
            this.fail(e);
        }
        catch (Exception e) {
            log.error(errorMsg, (Throwable)e);
            new OperationException(errorMsg, (Throwable)e);
        }
    }

    private void evaluateValidityAndUpdateTableMeta() throws OperationException {
        boolean validationResult = this.getValidationResult();
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.tempTable.getId());
        tmc.setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{new DataValidationMetadata(this.validationExpression, "", validationResult)});
    }

    private boolean getValidationResult() throws OperationException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.connectionProvider.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.generateGetValidationResultSQLQuery());
            if (!rs.next()) break block5;
            boolean bl = rs.getBoolean(0);
            DbUtils.closeQuietly((Connection)conn);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)rs);
            return bl;
        }
        try {
            try {
                throw new OperationException("Unable to obtain validation result");
            }
            catch (SQLException e) {
                String msg = "Unable to query table";
                log.error(msg, (Throwable)e);
                throw new OperationException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn);
            DbUtils.closeQuietly(stmt);
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
    }

    private String generateGetValidationResultSQLQuery() {
        return String.format("SELECT bool_and(%s) from %s", this.validationColumn.getName(), this.tempTable.getName());
    }

    private void fillValidationColumn() throws OperationException {
        this.executeSQLBatchCommands(this.connectionProvider, new String[]{this.generateSetAllFalseSqlCommand(), this.generateValidationSqlCommand()});
    }

    private String generateSetAllFalseSqlCommand() {
        return String.format("UPDATE %s SET %s = false;", this.tempTable.getName(), this.validationColumn.getName());
    }

    private String generateValidationSqlCommand() throws OperationException {
        try {
            return String.format("UPDATE %s SET %s = true WHERE %s;", this.tempTable.getName(), this.validationColumn.getName(), this.evaluatorFactory.getEvaluator(this.validationExpression).evaluate());
        }
        catch (EvaluatorException e) {
            throw new OperationException("Unable to evaluate epression", (Throwable)e);
        }
    }

    private void createNewTable() {
        TableCreator tc = this.cubeManager.createTable(this.targetTable.getTableType());
        tc.like(this.targetTable, true);
        this.validationColumn = new Column((DataType)new BooleanType(), (ColumnType)new ValidationColumnType());
        tc.addColumn(this.validationColumn);
        this.tempTable = tc.create();
        log.debug("Created temporary table:\n" + this.tempTable);
    }
}

