/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeToAttributeColumn
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(ChangeToAttributeColumn.class);
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cubeManager;
    private Table targetTable;
    private Column targetColumn;
    private DataType targetType;
    private Table newTable;

    public ChangeToAttributeColumn(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.createNewTable();
        this.updateProgress(0.5f);
        this.fillNewTableWithData();
        return new ImmutableWorkerResult(this.newTable);
    }

    private void retrieveParameters() {
        this.targetType = (DataType)this.getSourceInvocation().getParameterInstances().get(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER.getIdentifier());
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
    }

    private void createNewTable() {
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        log.debug("Column to remove: " + this.targetColumn);
        for (Column oldColumn : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            Column newColumn = null;
            if (oldColumn.equals((Object)this.targetColumn)) {
                newColumn = new Column(this.targetColumn.getLocalId(), this.targetType, (ColumnType)new AttributeColumnType());
                newColumn.setAllMetadata(this.targetColumn.getAllMetadata());
                newColumn.setName(this.targetColumn.getName());
            } else {
                newColumn = oldColumn;
            }
            tableCreator.addColumn(newColumn);
        }
        this.newTable = tableCreator.create();
        log.trace("Empty table created:\n" + this.newTable);
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.generateSQLFillCommand();
        try {
            SQLHelper.executeSQLCommand(sqlCommand, this.connectionProvider);
        }
        catch (SQLException e) {
            log.error("Unable to execute sql query", (Throwable)e);
            throw new WorkerException("Unable to fill new table with data", (Throwable)e);
        }
    }

    private String generateSQLFillCommand() {
        TypeTransitionSQLHandler typeTransitionHandler = TypeTransitionSQLHandler.getHandler(this.targetColumn.getDataType(), this.targetType);
        log.debug("Using transition handler: " + typeTransitionHandler.getClass().getSimpleName());
        return typeTransitionHandler.getCopyDataSQLCommand(this.newTable, this.targetTable, this.targetColumn);
    }
}

