/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.CodelistValidator;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateValuesInColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class CodelistValidatorFactory
extends TableValidatorFactory {
    private static final OperationId OPERATION_ID = new OperationId(5001L);
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private DuplicateValuesInColumnValidatorFactory duplicateInColumnFactory;
    private ValidateDataWithExpressionFactory validateDataWithExpressionFactory;
    private DuplicateRowValidatorFactory duplicateRowsFactory;

    @Inject
    public CodelistValidatorFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, DuplicateValuesInColumnValidatorFactory duplicateInColumnFactory, ValidateDataWithExpressionFactory validateDataWithExpressionFactory, DuplicateRowValidatorFactory duplicateRowsFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.duplicateInColumnFactory = duplicateInColumnFactory;
        this.validateDataWithExpressionFactory = validateDataWithExpressionFactory;
        this.duplicateRowsFactory = duplicateRowsFactory;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation);
        return new CodelistValidator(invocation, this.cubeManager, this.connectionProvider, this.duplicateInColumnFactory, this.validateDataWithExpressionFactory, this.duplicateRowsFactory);
    }

    protected String getOperationName() {
        return "Codelist validation";
    }

    protected String getOperationDescription() {
        return "Validates the selected table against all constraints defined for a Codelist.";
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }
}

