/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationHelper {
    private static final Logger log = LoggerFactory.getLogger(ValidationHelper.class);

    public static boolean evaluateValidationColumnValidity(DatabaseConnectionProvider connectionProvider, String tablename, String validationColumnName) throws WorkerException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            conn = connectionProvider.getConnection();
            stmt = conn.createStatement();
            String sqlQuery = ValidationHelper.generateGetValidationResultSQLQuery(tablename, validationColumnName);
            log.debug("Executing query:" + sqlQuery);
            rs = stmt.executeQuery(sqlQuery);
            if (!rs.next()) break block5;
            boolean bl = rs.getBoolean(1);
            DbUtils.closeQuietly((Connection)conn);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)rs);
            return bl;
        }
        try {
            try {
                throw new WorkerException("Unable to obtain validation result");
            }
            catch (SQLException e) {
                String msg = "Unable to query table";
                log.error(msg, (Throwable)e);
                throw new WorkerException(msg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
    }

    private static String generateGetValidationResultSQLQuery(String tableName, String validationColumnName) {
        return String.format("SELECT bool_and(%s) from %s;", validationColumnName, tableName);
    }
}

