/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import java.util.Iterator;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ViewColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.DatasetViewTableMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.TableRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateView
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(CreateView.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetDataset;

    public CreateView(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, OperationInvocation invocation) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.targetDataset = cubeManager.getTable(invocation.getTargetTableId());
    }

    protected WorkerResult execute() throws WorkerException {
        Table viewTable = this.createDatasetViewTable();
        this.updateProgress(0.1f);
        String sql = this.createSQLStatement(viewTable);
        this.updateProgress(0.3f);
        this.executeSQLCommand(sql);
        log.trace("Created view table:\n" + viewTable);
        Table resultTable = this.createResultTable(viewTable);
        return new ImmutableWorkerResult(resultTable);
    }

    private void executeSQLCommand(String sql) throws WorkerException {
        try {
            SQLHelper.executeSQLCommand(sql, this.connectionProvider);
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while executing SQL Command", (Throwable)e);
        }
    }

    private Table createResultTable(Table viewTable) {
        TableMetaCreator tmc = this.cubeManager.modifyTableMeta(this.targetDataset.getId());
        tmc.setTableMetadata(new TableMetadata[]{new DatasetViewTableMetadata(viewTable.getId())});
        return tmc.create();
    }

    private String createSQLStatement(Table viewTable) {
        StringBuilder sqlSelect = new StringBuilder("SELECT ");
        this.appendDatasetColumnNames(sqlSelect);
        sqlSelect.append("FROM " + this.targetDataset.getName() + " AS d ");
        int i = 0;
        for (TableRelationship rel : this.targetDataset.getRelationships()) {
            Table linkedTable = this.cubeManager.getTable(rel.getTargetTableId());
            String linkedTableAlias = "c" + i;
            String linkedTableName = linkedTable.getName();
            String foreignKeyColumnName = this.targetDataset.getColumnById(rel.getForeignKeyColumnId()).getName();
            String targetIdColumnName = ((Column)linkedTable.getColumnsByType(new Class[]{IdColumnType.class}).get(0)).getName();
            sqlSelect.append(String.format("LEFT JOIN %1$s AS %2$s ON d.%3$s = %2$s.%4$s", linkedTableName, linkedTableAlias, foreignKeyColumnName, targetIdColumnName));
            ++i;
        }
        StringBuilder orderedColumnNames = new StringBuilder();
        for (Column column : viewTable.getColumns()) {
            if (column.getColumnType().equals((Object)new IdColumnType())) continue;
            orderedColumnNames.append(String.valueOf(column.getName()) + " ,");
        }
        orderedColumnNames.deleteCharAt(orderedColumnNames.length() - 1);
        String sqlInsert = String.format("INSERT INTO %s (%s) ", viewTable.getName(), orderedColumnNames);
        StringBuilder sql = new StringBuilder(sqlInsert).append((CharSequence)sqlSelect).append(";");
        log.trace("Generated \"view filling\" SQL statement:\n" + sql);
        return sql.toString();
    }

    private void appendDatasetColumnNames(StringBuilder sqlSelect) {
        int relIndex = 0;
        for (Column column : this.targetDataset.getColumns()) {
            if (column.getColumnType().equals((Object)new IdColumnType())) continue;
            sqlSelect.append("d.").append(column.getName()).append(" ,");
            if (column.getRelationship() == null) continue;
            Table linkedTable = this.cubeManager.getTable(column.getRelationship().getTargetTableId());
            for (Column relColumn : linkedTable.getColumnsByType(new Class[]{CodeColumnType.class, CodeNameColumnType.class, CodeDescriptionColumnType.class})) {
                sqlSelect.append("c").append(relIndex).append(".").append(relColumn.getName()).append(" ,");
            }
            ++relIndex;
        }
        sqlSelect.deleteCharAt(sqlSelect.length() - 1);
    }

    private Table createDatasetViewTable() throws WorkerException {
        try {
            TableCreator tableCreator = this.cubeManager.createTable((TableType)new DatasetViewTableType());
            tableCreator.like(this.targetDataset, false);
            List dimensionColumns = this.targetDataset.getColumnsByType(new ColumnType[]{new DimensionColumnType(), new TimeDimensionColumnType()});
            Iterator iterator = dimensionColumns.iterator();
            while (iterator.hasNext()) {
                Column dimensionColumn;
                Column afterColumn = dimensionColumn = (Column)iterator.next();
                Table dimensionTable = this.cubeManager.getTable(dimensionColumn.getRelationship().getTargetTableId());
                for (Column column : dimensionTable.getColumnsByType(new Class[]{CodeColumnType.class, CodeNameColumnType.class, CodeDescriptionColumnType.class})) {
                    column.setMetadata((ColumnMetadata)new ViewColumnMetadata(dimensionTable.getId(), column.getLocalId(), dimensionColumn.getLocalId()));
                    tableCreator.addColumnAfter(column, afterColumn);
                    afterColumn = column;
                }
            }
            Table viewTable = tableCreator.create();
            log.debug("Created view: " + viewTable);
            return viewTable;
        }
        catch (Exception e) {
            throw new WorkerException("Unable to create dataset view", (Throwable)e);
        }
    }
}

