/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.datatype;

import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;

public class NumericToIntegerSQLHandler
extends TypeTransitionSQLHandler {
    @Override
    public String getCopyDataSQLCommand(Table newTable, Table targetTable, Column targetColumn) {
        StringBuilder sqlBuilder = new StringBuilder();
        List columnsToCopy = newTable.getColumns();
        String columnNamesSnippet = SQLHelper.generateColumnNameSnippet(columnsToCopy);
        sqlBuilder.append(String.format("INSERT INTO %s (%s) ", newTable.getName(), columnNamesSnippet));
        columnNamesSnippet = this.generateTypedColumnNameSnippet(newTable, targetColumn);
        sqlBuilder.append(String.format("SELECT %s FROM %s;", columnNamesSnippet, targetTable.getName()));
        return sqlBuilder.toString();
    }

    private String generateTypedColumnNameSnippet(Table newTable, Column targetColumn) {
        StringBuilder sb = new StringBuilder();
        for (Column column : newTable.getColumns()) {
            if (column.getName().equals(targetColumn.getName())) {
                sb.append(String.format("CAST(%s AS integer)", column.getName()));
            } else {
                sb.append(column.getName());
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String getFillValidationColumnSQLCommand(Table validationTable, Column validationColumn, Column targetColumn) {
        throw new UnsupportedOperationException("The cast from Numeric to Integer should never fail");
    }
}

