/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnTypeCastValidator
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(ColumnTypeCastValidator.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Table targetTable;
    private Column targetColumn;
    private DataType targetType;
    private Column validationColumn;

    public ColumnTypeCastValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f);
        this.addValidationColumnToTable();
        this.updateProgress(0.4f);
        this.fillNewTableWithData();
        this.updateProgress(0.8f);
        this.createUpdatedTableMeta();
        return new ImmutableWorkerResult(this.targetTable);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        this.targetType = (DataType)OperationHelper.getParameter(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER, this.getSourceInvocation());
    }

    private void addValidationColumnToTable() {
        ValidationReferencesMetadata referencesMeta;
        this.createValidationColumn();
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        if (this.targetColumn.contains(ValidationReferencesMetadata.class)) {
            referencesMeta = (ValidationReferencesMetadata)this.targetColumn.getMetadata(ValidationReferencesMetadata.class);
            referencesMeta.add(this.validationColumn.getLocalId());
        } else {
            referencesMeta = new ValidationReferencesMetadata(this.validationColumn.getLocalId());
        }
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.targetColumn.getLocalId(), new ColumnMetadata[]{referencesMeta}).create();
    }

    private void createValidationColumn() {
        String columnLabel = this.retrieveTargetColumnLabel();
        DataValidationMetadata validationMeta = this.createDataValidationMetadata(false);
        this.validationColumn = ValidationColumnFactory.create((LocalizedText)new ImmutableLocalizedText(String.format("Is %s a valid %s?", columnLabel, this.targetType.getName())), (DataValidationMetadata)validationMeta);
    }

    private DataValidationMetadata createDataValidationMetadata(boolean valid) {
        String columnLabel = this.retrieveTargetColumnLabel();
        ImmutableLocalizedText validationText = new ImmutableLocalizedText(String.format("Tells whether %s can be casted to a %s value", columnLabel, this.targetType.getName()));
        DataValidationMetadata validationMeta = new DataValidationMetadata((LocalizedText)validationText, valid);
        return validationMeta;
    }

    private String retrieveTargetColumnLabel() {
        return OperationHelper.retrieveColumnLabel(this.targetColumn);
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.generateFillTableSQL();
        try {
            SQLHelper.executeSQLCommand(sqlCommand, this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to evaluate validation result", (Throwable)e);
        }
    }

    private String generateFillTableSQL() {
        TypeTransitionSQLHandler typeTransitionHandler = TypeTransitionSQLHandler.getHandler(this.targetColumn.getDataType(), this.targetType);
        log.debug("Using Type transition handler: " + typeTransitionHandler.getClass().getSimpleName());
        return typeTransitionHandler.getFillValidationColumnSQLCommand(this.targetTable, this.validationColumn, this.targetColumn);
    }

    private void createUpdatedTableMeta() throws WorkerException {
        boolean valid = ValidationHelper.evaluateValidationColumnValidity(this.connectionProvider, this.targetTable.getName(), this.validationColumn.getName());
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{this.createDataValidationMetadata(valid)}).create();
    }
}

