/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTextTypedColumnTypeTransformation
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(SimpleTextTypedColumnTypeTransformation.class);
    private ColumnType managedColumnType;
    private Table targetTable;
    private Column targetColumn;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider databaseConnectionProvider;
    Table newTable = null;

    public SimpleTextTypedColumnTypeTransformation(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider databaseConnectionProvider, ColumnType managedColumnType) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.databaseConnectionProvider = databaseConnectionProvider;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
        this.managedColumnType = managedColumnType;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f);
        this.createNewTable();
        this.updateProgress(0.5f);
        this.fillNewTableWithData();
        return new ImmutableWorkerResult(this.newTable);
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.generateSQLFillCommand(this.targetTable, this.newTable);
        try {
            SQLHelper.executeSQLCommand(sqlCommand, this.databaseConnectionProvider);
        }
        catch (Exception e) {
            throw new WorkerException("Unable to fill new table with data", (Throwable)e);
        }
    }

    private void createNewTable() {
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        log.debug("Column to remove: " + this.targetColumn);
        for (Column oldColumn : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            Column newColumn = null;
            if (oldColumn.equals((Object)this.targetColumn)) {
                newColumn = new Column(this.targetColumn.getLocalId(), (DataType)new TextType(), this.managedColumnType);
                newColumn.setAllMetadata(this.targetColumn.getAllMetadata());
                newColumn.setName(this.targetColumn.getName());
            } else {
                newColumn = oldColumn;
            }
            tableCreator.addColumn(newColumn);
        }
        this.newTable = tableCreator.create();
        log.trace("Empty table created:\n" + this.newTable);
    }

    private String generateSQLFillCommand(Table sourceTable, Table newTable) {
        StringBuilder sqlBuilder = new StringBuilder();
        List columnsToCopy = newTable.getColumns();
        String columnNamesSnippet = SQLHelper.generateColumnNameSnippet(columnsToCopy);
        sqlBuilder.append(String.format("INSERT INTO %s (%s) ", newTable.getName(), columnNamesSnippet));
        sqlBuilder.append(String.format("SELECT %s FROM %s;", columnNamesSnippet, sourceTable.getName()));
        return sqlBuilder.toString();
    }
}

