package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.time.PeriodTypeHelperProvider;
import org.gcube.data.analysis.tabulardata.operation.validation.TimeDimensionColumnValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class ChangeToTimeDimensionColumnFactory extends ChangeColumnTypeTransformationFactory {

	private final static ColumnType MANAGED_COLUMN_TYPE = new TimeDimensionColumnType();

	private static final OperationId OPERATION_ID = new OperationId(2007);
	
	private final static List<Parameter> parameters = new ArrayList<Parameter>();

	static {
		parameters.add(TimeDimensionColumnValidatorFactory.PERIOD_FORMAT_PARAMETER);
	}

	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;

	private TimeDimensionColumnValidatorFactory fallbackFactory;
	
	private PeriodTypeHelperProvider periodTypeHelperProvider;

	@Inject
	public ChangeToTimeDimensionColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider,
			TimeDimensionColumnValidatorFactory fallbackFactory,PeriodTypeHelperProvider periodTypeHelperProvider) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.fallbackFactory = fallbackFactory;
		this.periodTypeHelperProvider = periodTypeHelperProvider;
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		checkTargetColumnEligibility(invocation);
		return new ChangeToTimeDimensionColumn(invocation, cubeManager, connectionProvider, periodTypeHelperProvider);
	}

	private void checkTargetColumnEligibility(OperationInvocation invocation) throws InvalidInvocationException {
		Table targetTable = cubeManager.getTable(invocation.getTargetTableId());
		Column column = targetTable.getColumnById(invocation.getTargetColumnId());
		if (!(column.getDataType() instanceof TextType))
			throw new InvalidInvocationException(invocation,
					"A text type column is needed in order to perform time dimension transformation");
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return MANAGED_COLUMN_TYPE;
	}

	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}

	@Override
	protected OperationId getOperationId() {
		return OPERATION_ID;
	}
	
	
	@Override
	public List<WorkerFactory> getPrecoditionValidations() {
		return Arrays.asList(new WorkerFactory[]{
				fallbackFactory
		});
	}
}
