/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.SimpleTextTypedColumnTypeTransformation;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public abstract class SimpleTextTypedColumnTypeTransformationFactory
extends ChangeColumnTypeTransformationFactory {
    public static final List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();
    private static final List<Parameter> parameters = new ArrayList<Parameter>();
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cubeManager;

    static {
        allowedSourceColumnTypes.add((ColumnType)new AnnotationColumnType());
        allowedSourceColumnTypes.add((ColumnType)new MeasureColumnType());
        allowedSourceColumnTypes.add((ColumnType)new AttributeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeNameColumnType());
        allowedSourceColumnTypes.add((ColumnType)new CodeDescriptionColumnType());
        parameters.add((Parameter)ADDITIONAL_META_PARAMETER);
    }

    public SimpleTextTypedColumnTypeTransformationFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkAllowedColumnTypeTransition(invocation, this.cubeManager);
        invocation.getParameterInstances().put(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER.getIdentifier(), new TextType());
        return new SimpleTextTypedColumnTypeTransformation(invocation, this.cubeManager, this.connectionProvider, this.getManagedColumnType());
    }

    @Override
    protected List<ColumnType> getAllowedSourceColumnTypes() {
        return allowedSourceColumnTypes;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }
}

