/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.factories.ValidationColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.ValidationHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateValuesInColumnValidator
extends Worker {
    private static final Logger log = LoggerFactory.getLogger(DuplicateValuesInColumnValidator.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private Table targetTable;
    private Column targetColumn;
    private Column validationColumn;

    public DuplicateValuesInColumnValidator(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory factory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = factory;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.3f);
        this.createNewTableWithValidationColumn();
        this.updateProgress(0.5f);
        this.fillNewTableWithData();
        this.updateProgress(0.8f);
        this.evaluateValidityAndUpdateTableMeta();
        return new ImmutableWorkerResult(this.targetTable);
    }

    private void retrieveParameters() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
    }

    private void createNewTableWithValidationColumn() {
        DataValidationMetadata dataValidationMetadata = this.createDataValidationMetadata(0);
        this.validationColumn = new ValidationColumnFactory().create((LocalizedText)new ImmutableLocalizedText("Unique " + OperationHelper.retrieveColumnLabel(this.targetColumn)), dataValidationMetadata);
        this.targetTable = this.cubeManager.addValidations(this.targetTable.getId(), new Column[]{this.validationColumn});
        ValidationReferencesMetadata refreferenceMeta = new ValidationReferencesMetadata(new Column[]{this.targetColumn});
        this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{refreferenceMeta}).create();
    }

    private DataValidationMetadata createDataValidationMetadata(int count) {
        return new DataValidationMetadata((LocalizedText)new ImmutableLocalizedText("True when the value in column " + OperationHelper.retrieveColumnLabel(this.targetColumn) + " is not a duplicate, false otherwise"), count);
    }

    private void fillNewTableWithData() throws WorkerException {
        try {
            SQLHelper.executeSQLBatchCommands(this.connectionProvider, this.createSetAllTrueSQL(), this.createSetFalseOnDuplicatesSQL());
        }
        catch (Exception e) {
            String msg = "Unable to perform SQL operation";
            log.error(msg, (Throwable)e);
            throw new WorkerException(msg);
        }
    }

    private String createSetAllTrueSQL() {
        return String.format("UPDATE %1$s as newtable SET %2$s = true;", this.targetTable.getName(), this.validationColumn.getName());
    }

    private String createSetFalseOnDuplicatesSQL() {
        return String.format("UPDATE %2$s as target set %3$s=false from  (select distinct min(id) as m , %1$s from  %2$s group by %1$s) as dist where dist.%1$s= target.%1$s and id!=dist.m;", this.targetColumn.getName(), this.targetTable.getName(), this.validationColumn.getName());
    }

    private void evaluateValidityAndUpdateTableMeta() throws WorkerException {
        try {
            int invalidCount = ValidationHelper.getErrorCount(this.connectionProvider, this.targetTable, this.validationColumn, this.evaluatorFactory);
            GlobalDataValidationReportMetadata globalMeta = ValidationHelper.createDataValidationReport(this.validationColumn);
            this.targetTable = this.cubeManager.modifyTableMeta(this.targetTable.getId()).setColumnMetadata(this.validationColumn.getLocalId(), new ColumnMetadata[]{this.createDataValidationMetadata(invalidCount)}).setTableMetadata(new TableMetadata[]{globalMeta}).create();
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate global validation", (Throwable)e);
        }
    }
}

