package org.gcube.data.analysis.tabulardata.operation.time;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@Singleton
public class DayHelper implements PeriodTypeHelper {

	private CubeManager cubeManager;

	@Inject
	public DayHelper(CubeManager cubeManager) {
		this.cubeManager = cubeManager;
	}

	@Override
	public String getFillValidationColumnSQL(String validationTableName, String validationColumnName,
			String targetColumnName) {
		return String.format("UPDATE %s SET %s = is_valid_date(%s)", validationTableName, validationColumnName,
				targetColumnName);
	}

	@Override
	public Table createTimeCodelist() {
		return cubeManager.createTimeCodelist(PeriodType.DAY);
	}

	@Override
	public PeriodType getManagedPeriodType() {
		return PeriodType.DAY;
	}
		
	
	@Override
	public String getColumnName() {
		return "day_code";
	}

	@Override
	public String getFillTimeCodelistSQL(String targetTableName, String targetColumnName, String timeTableName) {
		return String.format("INSERT INTO %s ( day_code ) SELECT DISTINCT(normalize_day(%s)) FROM %s;", timeTableName, 
				targetColumnName, targetTableName);
	}
	
	public String getUpdateDimensionColumnSQL(String targetTableName, String targetColumnName, String newTableName, String timeDimensionColumnName,String timeTableName){
		return String.format("" +
				"WITH id_codes AS (" +
				"	SELECT original.id AS tuple_id, time_codelist.id AS time_id, day_code " +
				"	FROM %1$s AS original JOIN %2$s AS time_codelist ON ( normalize_day(%3$s) = day_code )" +
				") " +
				"UPDATE %4$s " +
				"SET %5$s = (SELECT time_id FROM id_codes WHERE %4$s.id = id_codes.tuple_id);", 
				targetTableName, timeTableName, targetColumnName, newTableName, timeDimensionColumnName
				);
	}

}
