/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeToAttributeColumn
extends DataWorker {
    private static final Logger log = LoggerFactory.getLogger(ChangeToAttributeColumn.class);
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cubeManager;
    private Table targetTable;
    private Column targetColumn;
    private DataType targetType;
    private Table newTable;
    private Table diffTable;

    public ChangeToAttributeColumn(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.retrieveParameters();
        this.updateProgress(0.1f, "creating new table");
        this.createNewTable();
        this.updateProgress(0.5f, "filling table with data");
        this.fillNewTableWithData();
        this.updateProgress(0.8f, "preparating table for future rollback");
        this.diffTable = this.createDiff(this.targetTable, this.targetColumn);
        return new ImmutableWorkerResult(this.newTable, this.diffTable);
    }

    private void retrieveParameters() {
        this.targetType = (DataType)this.getSourceInvocation().getParameterInstances().get(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER.getIdentifier());
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
    }

    private void createNewTable() {
        TableCreator tableCreator = this.cubeManager.createTable(this.targetTable.getTableType());
        log.debug("Column to remove: " + this.targetColumn);
        for (Column oldColumn : this.targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            Column newColumn = null;
            if (oldColumn.equals((Object)this.targetColumn)) {
                if (this.targetColumn.getColumnType() instanceof DimensionColumnType) {
                    ColumnRelationship cr = this.targetColumn.getRelationship();
                    Column referencedColumn = this.cubeManager.getTable(cr.getTargetTableId()).getColumnById(cr.getTargetColumnId());
                    newColumn = new Column(this.targetColumn.getLocalId(), referencedColumn.getDataType(), (ColumnType)new AttributeColumnType());
                } else {
                    newColumn = new Column(this.targetColumn.getLocalId(), this.targetType, (ColumnType)new AttributeColumnType());
                    newColumn.setName(this.targetColumn.getName());
                }
                Collection toSetMetadata = this.targetColumn.getAllMetadata();
                if (this.getSourceInvocation().getParameterInstances().containsKey(ChangeColumnTypeTransformationFactory.ADDITIONAL_META_PARAMETER.getIdentifier())) {
                    Object additional = this.getSourceInvocation().getParameterInstances().get(ChangeColumnTypeTransformationFactory.ADDITIONAL_META_PARAMETER.getIdentifier());
                    if (additional instanceof Collection) {
                        toSetMetadata.addAll((Collection)additional);
                    } else {
                        toSetMetadata.add((ColumnMetadata)additional);
                    }
                }
                newColumn.setAllMetadata(toSetMetadata);
            } else {
                newColumn = oldColumn;
            }
            tableCreator.addColumn(newColumn);
        }
        this.newTable = tableCreator.create();
        log.trace("Empty table created:\n" + this.newTable);
    }

    private void fillNewTableWithData() throws WorkerException {
        String sqlCommand = this.generateSQLFillCommand();
        try {
            SQLHelper.executeSQLCommand((String)sqlCommand, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            log.error("Unable to execute sql query " + sqlCommand, (Throwable)e);
            throw new WorkerException("Unable to fill new table with data", (Throwable)e);
        }
    }

    private String generateSQLFillCommand() {
        if (this.targetColumn.getColumnType() instanceof DimensionColumnType) {
            ColumnRelationship cr = this.targetColumn.getRelationship();
            Table referencedTable = this.cubeManager.getTable(cr.getTargetTableId());
            Column refencedColumn = referencedTable.getColumnById(cr.getTargetColumnId());
            ArrayList<Column> columns = new ArrayList<Column>();
            for (Column column : this.newTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
                if (column.equals((Object)this.targetColumn)) continue;
                columns.add(column);
            }
            String snippet = columns.size() > 0 ? SQLHelper.generateColumnNameSnippet(columns) : "";
            String toReturnQuery = String.format("INSERT INTO %1$s ( %2$s, %3$s ) SELECT %8$s, %4$s.%6$s FROM %4$s, %5$s WHERE %5$s.%7$s = %4$s.id", this.newTable.getName(), snippet, this.newTable.getColumnById(this.targetColumn.getLocalId()).getName(), referencedTable.getName(), this.targetTable.getName(), refencedColumn.getName(), this.targetColumn.getName(), this.getSelectStringColumns(columns, this.targetTable.getName()));
            log.debug("to return query is : " + toReturnQuery);
            return toReturnQuery;
        }
        TypeTransitionSQLHandler typeTransitionHandler = TypeTransitionSQLHandler.getHandler(this.targetColumn.getDataType(), this.targetType);
        log.debug("Using transition handler: " + typeTransitionHandler.getClass().getSimpleName());
        return typeTransitionHandler.getCopyDataSQLCommand(this.newTable, this.targetTable, this.targetColumn);
    }

    private String getSelectStringColumns(List<Column> columns, String tableName) {
        StringBuilder toReturn = new StringBuilder();
        for (Column col : columns) {
            toReturn.append(tableName).append(".").append(col.getName()).append(",");
        }
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        return toReturn.toString();
    }

    private Table createDiff(Table targetTable, Column targetColumn) {
        ArrayList<Column> columnsToRemove = new ArrayList<Column>(targetTable.getColumns().size() - 1);
        for (Column col : targetTable.getColumnsExceptTypes(new Class[]{IdColumnType.class})) {
            if (col.equals((Object)targetColumn)) continue;
            columnsToRemove.add(col);
        }
        log.trace(((Object)columnsToRemove).toString());
        TableCreator tableCreator = this.cubeManager.createTable(targetTable.getTableType()).like(targetTable, true, columnsToRemove);
        return tableCreator.create();
    }
}

